<?php
session_start();
require_once '../../config/db.php';

header('Content-Type: application/json');

$report_id = $_GET['report_id'] ?? 0;

if (!$report_id || !is_numeric($report_id)) {
    echo json_encode(['error' => 'Invalid report ID']);
    exit;
}

// Fetch all cheques for the report that are still unbanked
$sql = "
    SELECT id, customer_name, cheque_number, amount
    FROM till_report_cheques
    WHERE report_id = ?
      AND status = 'Unbanked'
      AND (deposited = 0 OR deposited IS NULL)
    ORDER BY created_at ASC
";

$stmt = $conn->prepare($sql);
$stmt->bind_param("i", $report_id);
$stmt->execute();
$result = $stmt->get_result();

$cheques = [];
while ($row = $result->fetch_assoc()) {
    $cheques[] = $row;
}

echo json_encode($cheques);
exit;
