<?php
// MUST be the first thing before ANY output
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
require_once '../../config/db.php';

// ✅ Handle form submission first before any output or layout
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $status = strtolower($_POST['status'] ?? 'active');

    if (!empty($name)) {
        // Check for duplicate
        $check = $conn->prepare("SELECT id FROM cashiers WHERE name = ?");
        $check->bind_param("s", $name);
        $check->execute();
        $check->store_result();

        if ($check->num_rows > 0) {
            header("Location: manage_cashiers.php?error=Cashier already exists");
            exit;
        }

        // Insert new cashier
        $stmt = $conn->prepare("INSERT INTO cashiers (name, status) VALUES (?, ?)");
        $stmt->bind_param("ss", $name, $status);
        if ($stmt->execute()) {
            header("Location: manage_cashiers.php?success=Cashier added successfully");
        } else {
            error_log("Insert error: " . $stmt->error);
            header("Location: manage_cashiers.php?error=Failed to add cashier");
        }
        exit;
    } else {
        header("Location: manage_cashiers.php?error=Cashier name is required");
        exit;
    }
}

// ✅ Now safe to include layout AFTER all headers are handled
include '../../includes/layout2.php';

// ✅ Fetch all cashiers
$cashiers = $conn->query("SELECT * FROM cashiers ORDER BY name")->fetch_all(MYSQLI_ASSOC);
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Manage Cashiers</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet" />
</head>
<body>
<div class="container mt-4 mb-5">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h4 class="fw-bold text-primary">🧾 Manage Cashiers</h4>
    <a href="../till/cashier_report.php" class="btn btn-outline-secondary btn-sm">← Back to Till Report</a>
  </div>

  <?php if (isset($_GET['success'])): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
      <?= htmlspecialchars($_GET['success']) ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php elseif (isset($_GET['error'])): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
      <?= htmlspecialchars($_GET['error']) ?>
      <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
  <?php endif; ?>

  <form method="POST" class="row g-2 mb-4 align-items-end">
    <div class="col-md-6">
      <label class="form-label">Cashier Name</label>
      <input type="text" name="name" class="form-control" placeholder="e.g. Joan Jeptoo" required>
    </div>
    <div class="col-md-3">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <option value="active">Active</option>
        <option value="inactive">Inactive</option>
      </select>
    </div>
    <div class="col-md-3">
      <button class="btn btn-primary w-100">➕ Add Cashier</button>
    </div>
  </form>

  <div class="table-responsive">
    <table class="table table-bordered table-hover table-sm align-middle">
      <thead class="table-light">
        <tr>
          <th>#</th>
          <th>Name</th>
          <th>Status</th>
          <th>Actions</th>
        </tr>
      </thead>
      <tbody>
        <?php if (count($cashiers) === 0): ?>
          <tr><td colspan="4" class="text-center text-muted">No cashiers found.</td></tr>
        <?php else: ?>
          <?php foreach ($cashiers as $index => $c): ?>
            <tr>
              <td><?= $index + 1 ?></td>
              <td><?= htmlspecialchars($c['name']) ?></td>
              <td>
                <span class="badge bg-<?= $c['status'] === 'active' ? 'success' : 'secondary' ?>">
                  <?= ucfirst($c['status']) ?>
                </span>
              </td>
              <td class="d-flex gap-2">
  <a href="edit_cashier.php?id=<?= $c['id'] ?>" class="btn btn-sm btn-outline-primary">✏️ Edit</a>
  <a href="delete_cashier.php?id=<?= $c['id'] ?>"
     class="btn btn-sm btn-outline-danger"
     onclick="return confirm('Are you sure you want to delete this cashier?');">🗑️ Delete</a>
</td>

            </tr>
          <?php endforeach; ?>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
