<?php
session_start();
require_once '../config/db.php';
include '../includes/layout2.php';

if ($_SESSION['role'] !== 'Admin') {
    header("Location: unauthorized.php");
    exit;
}

// Flash messages
$successMsg = $_SESSION['success'] ?? '';
$errorMsg = $_SESSION['error'] ?? '';
unset($_SESSION['success'], $_SESSION['error']);

// Fetch users with branch and role
$users = $conn->query("
    SELECT u.*, b.branch_name, r.role_name 
    FROM users u
    LEFT JOIN branches b ON u.branch_id = b.id
    LEFT JOIN user_roles r ON u.role_id = r.id
    ORDER BY u.created_at DESC
");

// Load branches and roles for modal dropdowns
$branches = $conn->query("SELECT id, branch_name FROM branches WHERE status = 'active'");
$roles = $conn->query("SELECT id, role_name FROM user_roles");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Users | SmartPay360</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
  <script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
  <style>
    body {
      background: #f1f5f9;
      font-family: 'Segoe UI', sans-serif;
    }
    .badge-active { background-color: #198754; }
    .badge-inactive { background-color: #dc3545; }
    .form-label { font-weight: 500; }
  </style>
</head>
<body>

<?php if ($successMsg): ?>
  <div class="alert alert-success text-center mx-3 mt-3"><?= $successMsg ?></div>
<?php elseif ($errorMsg): ?>
  <div class="alert alert-danger text-center mx-3 mt-3"><?= $errorMsg ?></div>
<?php endif; ?>

<div class="container py-4">
  <div class="card shadow-sm">
    <div class="card-header d-flex justify-content-between align-items-center bg-primary text-white">
      <h5 class="mb-0">👥 User Management</h5>
      <button class="btn btn-light btn-sm" data-bs-toggle="modal" data-bs-target="#addModal">➕ New User</button>
    </div>
    <div class="card-body">

      <div class="mb-3">
        <input type="text" id="search" class="form-control" placeholder="🔍 Search by name, username, phone...">
      </div>

      <div class="table-responsive">
        <table class="table table-bordered table-hover" id="userTable">
          <thead class="table-primary">
            <tr>
              <th>#</th>
              <th>Full Name</th>
              <th>Username</th>
              <th>ID No.</th>
              <th>Phone</th>
              <th>Branch</th>
              <th>Role</th>
              <th>Status</th>
              <th>Actions</th>
            </tr>
          </thead>
          <tbody>
            <?php $sn = 1; while ($u = $users->fetch_assoc()): ?>
            <tr>
              <td><?= $sn++ ?></td>
              <td><?= htmlspecialchars($u['full_name']) ?></td>
              <td><?= htmlspecialchars($u['username']) ?></td>
              <td><?= htmlspecialchars($u['id_number']) ?></td>
              <td><?= htmlspecialchars($u['phone']) ?></td>
              <td><?= htmlspecialchars($u['branch_name']) ?></td>
              <td><?= htmlspecialchars($u['role_name']) ?></td>
              <td>
                <span class="badge <?= $u['status'] === 'active' ? 'badge-active' : 'badge-inactive' ?>">
                  <?= ucfirst($u['status']) ?>
                </span>
              </td>
              <td>
                <button 
                  class="btn btn-sm btn-primary editBtn" 
                  data-bs-toggle="modal" 
                  data-bs-target="#editModal"
                  data-id="<?= $u['id'] ?>"
                  data-full_name="<?= htmlspecialchars($u['full_name']) ?>"
                  data-username="<?= htmlspecialchars($u['username']) ?>"
                  data-id_number="<?= $u['id_number'] ?>"
                  data-phone="<?= $u['phone'] ?>"
                  data-branch="<?= $u['branch_id'] ?>"
                  data-role="<?= $u['role_id'] ?>"
                  data-status="<?= $u['status'] ?>"
                >Edit</button>
                <a href="delete_user.php?id=<?= $u['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Delete this user?')">Delete</a>
              </td>
            </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>

    </div>
  </div>
</div>

<!-- 🔧 Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <form method="post" action="update_user.php" class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">Edit User</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <input type="hidden" name="id" id="edit_id">
        <div class="mb-2"><label class="form-label">Full Name</label><input type="text" name="full_name" id="edit_full_name" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">Username</label><input type="text" name="username" id="edit_username" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">ID Number</label><input type="text" name="id_number" id="edit_id_number" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">Phone</label><input type="text" name="phone" id="edit_phone" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">Branch</label>
          <select name="branch_id" id="edit_branch" class="form-select" required>
            <?php $branches->data_seek(0); while ($b = $branches->fetch_assoc()): ?>
              <option value="<?= $b['id'] ?>"><?= $b['branch_name'] ?></option>
            <?php endwhile; ?>
          </select>
        </div>
        <div class="mb-2"><label class="form-label">Role</label>
          <select name="role_id" id="edit_role" class="form-select" required>
            <?php $roles->data_seek(0); while ($r = $roles->fetch_assoc()): ?>
              <option value="<?= $r['id'] ?>"><?= $r['role_name'] ?></option>
            <?php endwhile; ?>
          </select>
        </div>
        <div class="mb-2"><label class="form-label">Status</label>
          <select name="status" id="edit_status" class="form-select" required>
            <option value="active">Active</option>
            <option value="inactive">Inactive</option>
          </select>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="submit" class="btn btn-success">Update</button>
      </div>
    </form>
  </div>
</div>

<!-- ➕ Add User Modal -->
<div class="modal fade" id="addModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered">
    <form method="post" action="add_user.php" class="modal-content">
      <div class="modal-header bg-success text-white">
        <h5 class="modal-title">Add New User</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-2"><label class="form-label">Full Name</label><input type="text" name="full_name" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">Username</label><input type="text" name="username" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">ID Number</label><input type="text" name="id_number" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">Phone</label><input type="text" name="phone" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">Email</label><input type="email" name="email" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">Password</label><input type="password" name="password" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">Confirm Password</label><input type="password" name="confirm_password" class="form-control" required></div>
        <div class="mb-2"><label class="form-label">Branch</label>
          <select name="branch_id" class="form-select" required>
            <?php $branches->data_seek(0); while ($b = $branches->fetch_assoc()): ?>
              <option value="<?= $b['id'] ?>"><?= $b['branch_name'] ?></option>
            <?php endwhile; ?>
          </select>
        </div>
        <div class="mb-2"><label class="form-label">Role</label>
          <select name="role_id" class="form-select" required>
            <?php $roles->data_seek(0); while ($r = $roles->fetch_assoc()): ?>
              <option value="<?= $r['id'] ?>"><?= $r['role_name'] ?></option>
            <?php endwhile; ?>
          </select>
        </div>
        <div class="mb-2"><label class="form-label">Status</label>
          <select name="status" class="form-select" required>
            <option value="active">Active</option>
            <option value="inactive">Inactive</option>
          </select>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
        <button type="submit" class="btn btn-success">Create User</button>
      </div>
    </form>
  </div>
</div>

<script>
// Live search
$("#search").on("keyup", function() {
  let value = $(this).val().toLowerCase();
  $("#userTable tbody tr").filter(function() {
    $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
  });
});

// Populate Edit Modal
$(".editBtn").on("click", function() {
  $("#edit_id").val($(this).data("id"));
  $("#edit_full_name").val($(this).data("full_name"));
  $("#edit_username").val($(this).data("username"));
  $("#edit_id_number").val($(this).data("id_number"));
  $("#edit_phone").val($(this).data("phone"));
  $("#edit_branch").val($(this).data("branch"));
  $("#edit_role").val($(this).data("role"));
  $("#edit_status").val($(this).data("status"));
});
</script>
</body>
</html>
