<?php
session_start();
require_once '../config/db.php';

$error = "";
$redirect = $_GET['redirect'] ?? $_POST['redirect'] ?? '../index.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = trim($_POST['username']);
    $password = $_POST['password'];

    $stmt = $conn->prepare("SELECT u.*, r.role_name FROM users u JOIN user_roles r ON u.role_id = r.id WHERE u.username = ? AND u.status = 'active'");
    $stmt->bind_param("s", $username);
    $stmt->execute();
    $result = $stmt->get_result();
    $user = $result->fetch_assoc();

    if ($user && password_verify($password, $user['password'])) {
        $_SESSION['user_id'] = $user['id'];
        $_SESSION['username'] = $user['username'];
        $_SESSION['role'] = $user['role_name'];

        $conn->query("UPDATE users SET last_login = NOW() WHERE id = {$user['id']}");

        // Password expiry enforcement (non-admins)
        if ($user['role_name'] !== 'Admin') {
            $lastChanged = $user['password_changed_at'] ?? $user['created_at'];
            $expiryDate = date('Y-m-d H:i:s', strtotime($lastChanged . ' +7 days'));
            if (strtotime($expiryDate) < time()) {
                header("Location: change_password.php?force=1");
                exit;
            }
        }

        // Optional session flag to trigger welcome toast
        $_SESSION['just_logged_back'] = true;

        header("Location: " . urldecode($redirect));
        exit;
    } else {
        $error = "❌ Invalid username or password.";
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>SmartPay360 | Login</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: linear-gradient(to right, #006494, #003554);
      font-family: 'Segoe UI', sans-serif;
    }
    .login-box {
      max-width: 420px;
      margin: 80px auto;
      padding: 30px;
      background: #fff;
      border-radius: 14px;
      box-shadow: 0 0 15px rgba(0,0,0,0.1);
    }
    .login-header {
      text-align: center;
      margin-bottom: 25px;
    }
    .login-header h2 {
      font-weight: bold;
      color: #003554;
    }
    .form-control:focus {
      border-color: #006494;
      box-shadow: 0 0 0 0.2rem rgba(0,100,148,.25);
    }
    .btn-primary {
      background-color: #006494;
      border: none;
    }
    .btn-primary:hover {
      background-color: #004f73;
    }
    .logo {
      width: 100px;
      margin-bottom: 15px;
    }
  </style>
</head>
<body>
  <div class="login-box">
    <div class="login-header">
      <img src="../assets/icons/logo.png" alt="SmartPay360 Logo" class="logo">
      <h2>🔐 SmartPay360</h2>
      <p class="text-muted mb-0">Enter your credentials to continue</p>
    </div>

    <?php if ($error): ?>
      <div class="alert alert-danger text-center"><?= $error ?></div>
    <?php endif; ?>

    <form method="post" autocomplete="off">
      <input type="hidden" name="redirect" value="<?= htmlspecialchars($redirect) ?>">
      <div class="mb-3">
        <label class="form-label">Username</label>
        <input type="text" name="username" class="form-control" required autofocus>
      </div>
      <div class="mb-3">
        <label class="form-label">Password</label>
        <input type="password" name="password" class="form-control" required>
      </div>
      <button type="submit" class="btn btn-primary w-100">Login</button>
    </form>

    <div class="text-center mt-3">
      <a href="forgot_password.php" class="text-decoration-none">Forgot Password?</a><br>
      <a href="register.php" class="text-decoration-none text-primary fw-semibold">Create an account</a>
    </div>
  </div>
</body>
</html>
