<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Session Expired - SmartPay360</title>
  <meta http-equiv="refresh" content="10;url=/smartpay360/auth/login.php">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background-color: #f8f9fa;
      display: flex;
      height: 100vh;
      align-items: center;
      justify-content: center;
      text-align: center;
    }
    .holder {
      max-width: 400px;
      padding: 30px;
      background: white;
      border-radius: 10px;
      box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    }
    .holder img {
      width: 80px;
      margin-bottom: 20px;
    }
  </style>
</head>
<body>
  <div class="holder">
    <img src="/smartpay360/assets/icons/logo.png" alt="SmartPay360 Logo">
    <h4 class="text-danger mb-3">Session Expired</h4>
    <p>Your session has timed out due to inactivity or you have been logged out.</p>
    <p>You will be redirected to the login page shortly.</p>
    <a href="/smartpay360/auth/login.php" class="btn btn-primary mt-3">Login Now</a>
    <p class="text-muted mt-2" id="countdown">Redirecting in 10 seconds...</p>
  </div>

  <script>
    let seconds = 10;
    const countdownEl = document.getElementById('countdown');
    const interval = setInterval(() => {
      seconds--;
      countdownEl.textContent = `Redirecting in ${seconds} second${seconds !== 1 ? 's' : ''}...`;
      if (seconds <= 0) clearInterval(interval);
    }, 1000);
  </script>
</body>
</html>
