<?php if (!isset($_SESSION)) session_start(); ?>
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>SmartPay360</title>

  <!-- Bootstrap & Font Awesome -->
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css" rel="stylesheet">
  <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>


  <!-- Custom Styles -->
  <link rel="stylesheet" href="/smartpay360/assets/css/style.css">
</head>
<body>

<!-- Navbar -->
<nav class="navbar navbar-expand-lg navbar-dark bg-primary fixed-top shadow-sm" style="z-index: 1050;">
  <div class="container-fluid">
    <a class="navbar-brand fw-bold d-flex align-items-center" href="/smartpay360/index.php">
      <i class="fas fa-file-invoice-dollar me-2"></i> SmartPay360
    </a>

    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarCollapse">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarCollapse">
      <!-- Left navbar links -->
      <ul class="navbar-nav me-auto">
        <li class="nav-item">
          <a class="nav-link text-white" href="/smartpay360/index.php">Home</a>
        </li>
        <li class="nav-item">
          <a class="nav-link text-white" href="/smartpay360/modules/branches/list.php">Branches</a>
        </li>
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle text-white" href="#" id="navDropdown" role="button" data-bs-toggle="dropdown">
            Quick Links
          </a>
          <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="#">Supplier Statement</a></li>
            <li><a class="dropdown-item" href="#">Upload PDF</a></li>
          </ul>
        </li>
      </ul>

      <!-- Search -->
      <form class="d-flex me-3" role="search">
        <input class="form-control form-control-sm me-2" type="search" placeholder="Search" aria-label="Search">
        <button class="btn btn-sm btn-light" type="submit"><i class="fas fa-search"></i></button>
      </form>

      <!-- User Profile -->
      <ul class="navbar-nav mb-0">
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle text-white" href="#" id="userDropdown" data-bs-toggle="dropdown">
            <i class="fas fa-user-circle"></i> <?= $_SESSION['user_name'] ?? 'Account' ?></a>
          <ul class="dropdown-menu dropdown-menu-end">
            <li><a class="dropdown-item" href="#">Settings</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger" href="/smartpay360/auth/logout.php">Logout</a></li>
          </ul>
        </li>
      </ul>
    </div>
  </div>
</nav>

<!-- Sidebar -->
<div class="sidebar bg-dark text-white position-fixed vh-100 p-3 shadow-sm" style="width:240px; top:56px;">
  <ul class="nav flex-column">
    <li class="nav-item">
      <a class="nav-link text-white d-flex align-items-center" href="/smartpay360/index.php">
        <i class="fas fa-home me-2"></i> Dashboard
      </a>
    </li>
    <li class="nav-item">
      <a class="nav-link text-white d-flex align-items-center" href="/smartpay360/modules/suppliers/list.php">
        <i class="fas fa-truck me-2"></i> Suppliers
      </a>
    </li>
    <li class="nav-item">
      <a class="nav-link text-white d-flex align-items-center" href="/smartpay360/modules/branches/list.php">
        <i class="fas fa-code-branch me-2"></i> Branches
      </a>
    </li>

    <!-- Invoices (Collapsible) -->
    <li class="nav-item">
      <a class="nav-link text-white d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#invoicesMenu" role="button" aria-expanded="false" aria-controls="invoicesMenu">
        <span><i class="fas fa-file-invoice me-2"></i> Invoices</span>
        <i class="fas fa-chevron-down small"></i>
      </a>
      <div class="collapse" id="invoicesMenu">
        <ul class="nav flex-column ms-3">
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/invoices/list.php">All Invoices</a></li>
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/invoices/add.php">Add Invoice</a></li>
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/invoices/verify.php">Verify Workflow</a></li>
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/invoices/approve.php">Approval Flow</a></li>
        </ul>
      </div>
    </li>

    <!-- Credit Notes (Collapsible) -->
    <li class="nav-item">
      <a class="nav-link text-white d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#creditMenu" role="button" aria-expanded="false" aria-controls="creditMenu">
        <span><i class="fas fa-file-alt me-2"></i> Credit Notes</span>
        <i class="fas fa-chevron-down small"></i>
      </a>
      <div class="collapse" id="creditMenu">
        <ul class="nav flex-column ms-3">
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/credit_notes/list.php">All Credit Notes</a></li>
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/credit_notes/add.php">Add Credit Note</a></li>
        </ul>
      </div>
    </li>

    <!-- Payments (Collapsible) -->
    <li class="nav-item">
      <a class="nav-link text-white d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#paymentsMenu" role="button" aria-expanded="false" aria-controls="paymentsMenu">
        <span><i class="fas fa-money-check me-2"></i> Payments</span>
        <i class="fas fa-chevron-down small"></i>
      </a>
      <div class="collapse" id="paymentsMenu">
        <ul class="nav flex-column ms-3">
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/payments/list.php">All Payments</a></li>
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/payments/add.php">Add Payment</a></li>
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/payments/receipts.php">Payment Receipts</a></li>
        </ul>
      </div>
    </li>

    <!-- Petty Cash (Collapsible) -->
    <li class="nav-item">
      <a class="nav-link text-white d-flex justify-content-between align-items-center" data-bs-toggle="collapse" href="#pettyCashMenu" role="button" aria-expanded="false" aria-controls="pettyCashMenu">
        <span><i class="fas fa-wallet me-2"></i> Petty Cash</span>
        <i class="fas fa-chevron-down small"></i>
      </a>
      <div class="collapse" id="pettyCashMenu">
        <ul class="nav flex-column ms-3">
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/petty_cash/list.php">All Transactions</a></li>
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/petty_cash/add.php">Add Transaction</a></li>
          <li><a class="nav-link text-white-50 small" href="/smartpay360/modules/petty_cash/receipt.php">Petty Cash Receipts</a></li>
        </ul>
      </div>
    </li>

    <!-- Cheques -->
    <li class="nav-item">
      <a class="nav-link text-white d-flex align-items-center" href="/smartpay360/modules/cheques/list.php">
        <i class="fas fa-money-check-alt me-2"></i> Cheques
      </a>
    </li>

    <!-- Reports -->
    <li class="nav-item">
      <a class="nav-link text-white d-flex align-items-center" href="/smartpay360/modules/reports/summary.php">
        <i class="fas fa-chart-line me-2"></i> Reports
      </a>
    </li>
  </ul>
</div>

<!-- Custom CSS for Advanced Sidebar -->
<style>
.sidebar .nav-link {
  transition: all 0.3s ease;
  border-radius: 5px;
  padding: 10px 15px;
  margin-bottom: 5px;
}

.sidebar .nav-link:hover {
  background-color: rgba(255, 255, 255, 0.1);
  transform: translateX(5px);
}

.sidebar .nav-link.active {
  background-color: #007bff;
  font-weight: bold;
}

.sidebar .collapse .nav-link {
  padding: 8px 20px;
  font-size: 0.9rem;
}

.sidebar .collapse .nav-link:hover {
  background-color: rgba(255, 255, 255, 0.05);
}

.sidebar .fa-chevron-down {
  transition: transform 0.3s ease;
}

.sidebar .nav-link[aria-expanded="true"] .fa-chevron-down {
  transform: rotate(180deg);
}

.sidebar .collapse {
  transition: all 0.3s ease;
}
</style>

<!-- JavaScript for Active State -->
<script>
document.addEventListener('DOMContentLoaded', function () {
  const navLinks = document.querySelectorAll('.sidebar .nav-link');
  const currentPath = window.location.pathname;

  navLinks.forEach(link => {
    const href = link.getAttribute('href');
    if (href && currentPath.includes(href)) {
      link.classList.add('active');
      // Expand parent collapse if sub-link is active
      const parentCollapse = link.closest('.collapse');
      if (parentCollapse) {
        parentCollapse.classList.add('show');
        const parentLink = document.querySelector(`[href="#${parentCollapse.id}"]`);
        if (parentLink) parentLink.setAttribute('aria-expanded', 'true');
      }
    }
  });
});
</script>
    <li class="mt-3">
      <hr class="border-light">
      <a class="nav-link text-white small" href="/smartpay360/auth/logout.php">
        <i class="fas fa-sign-out-alt me-2"></i>Logout
      </a>
    </li>
  </ul>
</div>

<!-- Main Page -->
<main class="main-content" style="margin-left: 240px; padding: 80px 20px 20px;">
