<?php
require_once 'pdo_db.php';
session_start();

header('Content-Type: application/json');

// CSRF validation
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    echo json_encode(['success' => false, 'error' => 'Invalid CSRF token']);
    exit;
}

// Validate input
$input = json_decode(file_get_contents('php://input'), true);
if (!$input || !isset($input['layout_id']) || !isset($input['fields'])) {
    echo json_encode(['success' => false, 'error' => 'Invalid input']);
    exit;
}

$layout_id = (int)$input['layout_id'];
$date_format = isset($input['date_format']) ? filter_var($input['date_format'], FILTER_SANITIZE_STRING) : 'DD-MM-YYYY';
$fields = $input['fields'];

try {
    // Update layout date format
    $stmt = $pdo->prepare("UPDATE cheque_layouts SET date_format = ? WHERE id = ?");
    $stmt->execute([$date_format, $layout_id]);

    // Update or insert fields
    foreach ($fields as $field) {
        $field_id = strpos($field['id'], 'new_') === 0 ? null : (int)$field['id'];
        $params = [
            ':layout_id' => $layout_id,
            ':field_name' => filter_var($field['name'], FILTER_SANITIZE_STRING),
            ':position_x' => (int)$field['x'],
            ':position_y' => (int)$field['y'],
            ':font_size' => (int)$field['font_size'],
            ':font_family' => filter_var($field['font_family'], FILTER_SANITIZE_STRING),
            ':font_style' => filter_var($field['font_style'], FILTER_SANITIZE_STRING),
            ':font_color' => filter_var($field['font_color'], FILTER_SANITIZE_STRING),
            ':width' => (int)$field['width'],
            ':height' => (int)$field['height'],
            ':is_visible' => (int)$field['visible']
        ];

        if ($field_id) {
            // Update existing field
            $stmt = $pdo->prepare("UPDATE layout_fields SET 
                field_name = :field_name, position_x = :position_x, position_y = :position_y, 
                font_size = :font_size, font_family = :font_family, font_style = :font_style, 
                font_color = :font_color, width = :width, height = :height, is_visible = :is_visible 
                WHERE id = :id AND layout_id = :layout_id");
            $params[':id'] = $field_id;
        } else {
            // Insert new field
            $stmt = $pdo->prepare("INSERT INTO layout_fields 
                (layout_id, field_name, position_x, position_y, font_size, font_family, font_style, 
                font_color, width, height, is_visible) 
                VALUES (:layout_id, :field_name, :position_x, :position_y, :font_size, :font_family, 
                :font_style, :font_color, :width, :height, :is_visible)");
        }
        $stmt->execute($params);
    }

    echo json_encode(['success' => true]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'error' => 'Database error: ' . $e->getMessage()]);
}
?>