<?php
session_start();
$today = date('Y-m-d');

// Generate a unique form code
$form_code = 'CRF-' . date('Ymd') . '-' . strtoupper(substr(md5(uniqid(rand(), true)), 0, 6));
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Customer Credit Commitment Form - Delta Superstores Ltd</title>
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <style>
    @media print {
  @page {
    size: A4;
    margin: 15mm;
  }

  body {
    background: #fff !important;
    color: #000;
  }
.form-ref {
  text-align: right;
  font-size: 13px;
  margin-bottom: 10px;
  color: #000 !important;
}


  .no-print,
  nav,
  .navbar,
  .sidebar,
  .topbar,
  header,
  footer,
  #header,
  #sidebar,
  #nav {
    display: none !important;
    visibility: hidden !important;
    height: 0 !important;
    overflow: hidden !important;
  }

  .form-wrapper {
    margin: 0 !important;
    padding: 0 !important;
    box-shadow: none !important;
    width: 100% !important;
    page-break-after: auto;
  }

  html, body {
    width: 100%;
    height: 100%;
    overflow: visible !important;
  }
}

    body {
      font-family: 'Segoe UI', sans-serif;
      background: #fff;
      color: #000;
      padding: 15mm;
      margin: 0;
    }

    .header {
      text-align: center;
      border-bottom: 1px solid #0F3054;
      padding-bottom: 5px;
      margin-bottom: 10px;
    }

    .header img {
      height: 60px;
    }

    .header h1 {
      font-size: 18px;
      margin: 5px 0;
      text-transform: uppercase;
      color: #0F3054;
    }

    .company-contact {
      font-size: 11px;
      color: #555;
    }

    .section {
      margin-bottom: 12px;
    }

    .section-title {
      font-weight: 600;
      margin-bottom: 5px;
      font-size: 13px;
      color: #0F3054;
      border-bottom: 1px solid #ccc;
    }

    .terms {
      font-size: 12px;
      margin-top: 5px;
    }

    .terms li {
      margin-bottom: 5px;
    }

    .form-row {
      display: flex;
      gap: 10px;
      margin-bottom: 8px;
    }

    .form-col {
      flex: 1;
    }

    .label {
      font-size: 12px;
      font-weight: 500;
      margin-bottom: 2px;
    }

    .input-line {
      border-bottom: 1px solid #000;
      height: 18px;
      margin-bottom: 5px;
    }

    .signature-block {
      display: flex;
      justify-content: space-between;
      gap: 10px;
      margin-top: 15px;
    }

    .signature-box {
      flex: 1;
    }

    .signature-label {
      font-size: 12px;
      margin-bottom: 3px;
    }

    .signature-line {
      border-bottom: 1px solid #000;
      height: 25px;
    }

    .approval-section {
      margin-top: 20px;
      padding-top: 10px;
      border-top: 1px dashed #ccc;
    }

    .btn-print {
      margin: 15px 0;
      text-align: center;
    }

    .btn-print button {
      padding: 6px 18px;
      font-size: 14px;
      background: #0F3054;
      color: #fff;
      border: none;
      cursor: pointer;
      border-radius: 4px;
    }

    .footer-note {
      margin-top: 20px;
      font-size: 10px;
      text-align: center;
      color: #777;
    }
  </style>
</head>
<body>

<div class="header">
  <img src="../../assets/logo.png" alt="Delta Superstores Logo">
  <h1>Customer Credit Commitment Form</h1>
<div style="font-size: 13px; margin-top: 5px; color: #444;">
  <strong>Form Ref:</strong> <?= $form_code ?>
</div>

  <div class="company-contact">
    Delta Superstores Ltd, P.O. Box 215-30301 Nandi Hills, Kenya<br>
    Tel: +254 705 705 888 | Email: info@deltasuperstores.com
  </div>
</div>

<div class="section">
  <p class="terms">
    I hereby confirm that I have been granted credit facilities by <strong>Delta Superstores Ltd</strong> and acknowledge the following terms:
  </p>
  <ol class="terms">
    <li>All credit issued must be repaid within the agreed credit term (typically 30 days).</li>
    <li>Failure to repay on time may result in suspension of credit, interest charges, or legal recovery.</li>
    <li>Disputes must be raised within 7 days of invoice issuance.</li>
    <li>I accept full responsibility for all debts incurred under this credit facility.</li>
  </ol>
</div>

<div class="section">
  <div class="section-title">Customer Details</div>

  <div class="form-row">
    <div class="form-col">
      <div class="label">Full Name:</div>
      <div class="input-line"></div>
    </div>
    <div class="form-col">
      <div class="label">ID Number:</div>
      <div class="input-line"></div>
    </div>
  </div>

  <div class="form-row">
    <div class="form-col">
      <div class="label">Phone Number:</div>
      <div class="input-line"></div>
    </div>
    <div class="form-col">
      <div class="label">Business/Shop Name:</div>
      <div class="input-line"></div>
    </div>
  </div>

  <div class="form-row">
    <div class="form-col">
      <div class="label">Physical Address:</div>
      <div class="input-line"></div>
    </div>
    <div class="form-col">
      <div class="label">Requested Credit Limit (KSh):</div>
      <div class="input-line"></div>
    </div>
  </div>
</div>

<div class="section">
  <p class="terms">
    By signing below, I confirm the above information is true and accept the credit terms of Delta Superstores Ltd.
  </p>
</div>

<div class="signature-block">
  <div class="signature-box">
    <div class="signature-label">Customer Signature:</div>
    <div class="signature-line"></div>
  </div>
  <div class="signature-box">
    <div class="signature-label">Date:</div>
    <div class="signature-line"><?= $today ?></div>
  </div>
</div>

<div class="approval-section">
  <div class="section-title">Management Approval</div>

  <div class="signature-block">
    <div class="signature-box">
      <div class="signature-label">Credit Officer / Sales Rep:</div>
      <div class="signature-line"></div>
    </div>
    <div class="signature-box">
      <div class="signature-label">Date:</div>
      <div class="signature-line"></div>
    </div>
  </div>

  <div class="signature-block" style="margin-top: 12px;">
    <div class="signature-box">
      <div class="signature-label">Branch Manager Approval:</div>
      <div class="signature-line"></div>
    </div>
    <div class="signature-box">
      <div class="signature-label">Date:</div>
      <div class="signature-line"></div>
    </div>
  </div>

  <div class="signature-block" style="margin-top: 12px;">
    <div class="signature-box">
      <div class="signature-label">Director / Finance Approval:</div>
      <div class="signature-line"></div>
    </div>
    <div class="signature-box">
      <div class="signature-label">Date:</div>
      <div class="signature-line"></div>
    </div>
  </div>
</div>

<div class="btn-print no-print">
  <button onclick="window.print()">🖨️ Print Form</button>
</div>

<div class="footer-note">
  This document must be completed and signed by all parties before credit can be issued. Delta Superstores Ltd reserves the right to approve or reject any credit request.
</div>

</body>
</html>
