<?php
require_once '../../config/db.php';
require_once '../../lib/zkteco/src/Lib/ZKTeco.php';
require_once '../../lib/zkteco/src/Lib/Helper/Connect.php';
require_once '../../lib/zkteco/src/Lib/Helper/Util.php';
require_once '../../lib/zkteco/src/Lib/Helper/User.php';
require_once '../../lib/zkteco/src/Lib/Helper/Attendance.php';

use Jmrashed\Zkteco\Lib\ZKTeco;

$zk = new ZKTeco('192.168.1.247'); // your device IP

try {
    $zk->connect();
    echo "<h3>✅ Connected to ZKTeco device</h3>";

    // Fetch staff with defined zk_uid
    $sql = "SELECT staff_id, zk_uid, first_name, last_name FROM staff WHERE zk_uid IS NOT NULL AND zk_uid != ''";
    $result = $conn->query($sql);

    if (!$result || $result->num_rows === 0) {
        echo "⚠️ No staff found with ZK UID defined.";
        exit;
    }

    $count = 0;
    while ($row = $result->fetch_assoc()) {
        $userId = $row['zk_uid'];
        $name = strtoupper(trim($row['first_name'] . ' ' . $row['last_name']));

        // Set user on device: userId, userId, name, password, role
        $zk->setUser($userId, $userId, $name, '', 0);
        echo "✅ Uploaded: $name ($userId)<br>";
        $count++;
    }

    echo "<br><strong>✅ Uploaded $count staff record(s) to the device successfully.</strong>";

} catch (Exception $e) {
    echo "<strong>❌ Error:</strong> " . $e->getMessage();
}
?>
