<?php
session_start();
require_once '../../config/db.php';

// ✅ Session variable safety
$current_user = $_SESSION['username'] ?? '';
$current_role = $_SESSION['role'] ?? 'User';
$current_branch = $_SESSION['branch_id'] ?? 0;
$current_branch_name = $_SESSION['branch_name'] ?? '';

// ✅ CSRF token
if (empty($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// ✅ Edit mode check
$vehicle_id = isset($_GET['id']) ? intval($_GET['id']) : 0;
$edit_mode = $vehicle_id > 0;

$form_data = [
    'plate_number' => '',
    'make' => '',
    'model' => '',
    'year' => '',
    'fuel_type' => '',
    'tank_capacity' => '',
    'odometer' => '',
    'status' => 'Active',
    'branch_id' => $current_branch
];

if ($edit_mode) {
    $stmt = $conn->prepare("SELECT * FROM vehicles WHERE id = ?");
    $stmt->bind_param("i", $vehicle_id);
    $stmt->execute();
    $result = $stmt->get_result();
    if ($result->num_rows) {
        $form_data = $result->fetch_assoc();
    } else {
        $_SESSION['error'] = "Vehicle not found.";
        header("Location: list_vehicles.php");
        exit();
    }
    $stmt->close();
}

// ✅ Fetch branches if admin
$branches = [];
if ($current_role === 'Admin') {
    $result = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name ASC");
    while ($row = $result->fetch_assoc()) {
        $branches[] = $row;
    }
}
include '../../includes/layout2.php';

?>

<div class="main-content p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="fw-bold text-primary">
            <i class="fas fa-plus-circle me-2"></i><?= $edit_mode ? 'Edit' : 'Add' ?> Vehicle
        </h4>
        <a href="list_vehicles.php" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back to List</a>
    </div>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger"><?= $_SESSION['error']; unset($_SESSION['error']); ?></div>
    <?php endif; ?>

    <form method="POST" action="save_vehicle.php" class="card shadow p-4">
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?>">
        <input type="hidden" name="vehicle_id" value="<?= $vehicle_id ?>">

        <div class="row g-3">
            <div class="col-md-4">
                <label class="form-label">Plate Number *</label>
                <input type="text" name="plate_number" class="form-control" required value="<?= htmlspecialchars($form_data['plate_number']) ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Make *</label>
                <input type="text" name="make" class="form-control" required value="<?= htmlspecialchars($form_data['make']) ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Model *</label>
                <input type="text" name="model" class="form-control" required value="<?= htmlspecialchars($form_data['model']) ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">Year *</label>
                <input type="number" name="year" class="form-control" min="1990" max="<?= date('Y') ?>" required value="<?= $form_data['year'] ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">Fuel Type *</label>
                <select name="fuel_type" class="form-select" required>
                    <option value="">--Select--</option>
                    <option value="Petrol" <?= $form_data['fuel_type'] === 'Petrol' ? 'selected' : '' ?>>Petrol</option>
                    <option value="Diesel" <?= $form_data['fuel_type'] === 'Diesel' ? 'selected' : '' ?>>Diesel</option>
                </select>
            </div>
            <div class="col-md-3">
                <label class="form-label">Tank Capacity (Liters)</label>
                <input type="number" step="0.1" name="tank_capacity" class="form-control" value="<?= $form_data['tank_capacity'] ?>">
            </div>
            <div class="col-md-3">
                <label class="form-label">Odometer (km)</label>
                <input type="number" step="0.1" name="odometer" class="form-control" value="<?= $form_data['odometer'] ?>">
            </div>
            <div class="col-md-4">
                <label class="form-label">Status *</label>
                <select name="status" class="form-select" required>
                    <option value="Active" <?= $form_data['status'] === 'Active' ? 'selected' : '' ?>>Active</option>
                    <option value="Maintenance" <?= $form_data['status'] === 'Maintenance' ? 'selected' : '' ?>>Maintenance</option>
                    <option value="Inactive" <?= $form_data['status'] === 'Inactive' ? 'selected' : '' ?>>Inactive</option>
                </select>
            </div>
            <div class="col-md-4">
                <label class="form-label">Branch *</label>
                <?php if ($current_role === 'Admin'): ?>
                    <select name="branch_id" class="form-select" required>
                        <option value="">-- Select Branch --</option>
                        <?php foreach ($branches as $branch): ?>
                            <option value="<?= $branch['id'] ?>" <?= $branch['id'] == $form_data['branch_id'] ? 'selected' : '' ?>>
                                <?= htmlspecialchars($branch['branch_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                <?php else: ?>
                    <input type="hidden" name="branch_id" value="<?= $current_branch ?>">
                    <input type="text" class="form-control" value="<?= htmlspecialchars($current_branch_name) ?>" disabled>
                <?php endif; ?>
            </div>
        </div>

        <div class="mt-4">
            <button type="submit" class="btn btn-primary px-4">
                <i class="fas fa-save me-1"></i> <?= $edit_mode ? 'Update' : 'Save Vehicle' ?>
            </button>
        </div>
    </form>
</div>

<?php include '../../includes/footer.php'; ?>
