<?php
session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

// CSRF check
if ($_SERVER['REQUEST_METHOD'] !== 'POST' || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
    $_SESSION['error'] = "Invalid request or session expired.";
    header("Location: add_fuel.php");
    exit();
}

// Collect and validate input
$vehicle_id = intval($_POST['vehicle_id'] ?? 0);
$fuel_date = $_POST['fuel_date'] ?? '';
$station = trim($_POST['station'] ?? '');
$liters = floatval($_POST['liters'] ?? 0);
$cost = floatval($_POST['cost'] ?? 0);
$odometer = isset($_POST['odometer']) ? floatval($_POST['odometer']) : null;
$remarks = trim($_POST['remarks'] ?? '');
$user_id = $_SESSION['user_id'] ?? 0;

// Basic validations
if ($vehicle_id <= 0 || !$fuel_date || !$station || $liters <= 0 || $cost <= 0) {
    $_SESSION['error'] = "Please fill all required fields with valid data.";
    header("Location: add_fuel.php");
    exit();
}

// Prepare SQL insert
$stmt = $conn->prepare("INSERT INTO fuel_logs 
    (vehicle_id, fuel_date, station, liters, cost, odometer, remarks, created_by) 
    VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
if (!$stmt) {
    $_SESSION['error'] = "Database error: " . $conn->error;
    header("Location: add_fuel.php");
    exit();
}

$stmt->bind_param("isssddsi", $vehicle_id, $fuel_date, $station, $liters, $cost, $odometer, $remarks, $user_id);
$success = $stmt->execute();

if ($success) {
    $_SESSION['success'] = "Fuel entry saved successfully!";
} else {
    $_SESSION['error'] = "Error saving entry: " . $stmt->error;
}

$stmt->close();
header("Location: add_fuel.php");
exit();
