<?php
session_start();
require_once '../../config/db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: ../../login.php");
    exit();
}

$maintenance_id = intval($_GET['id'] ?? 0);
if ($maintenance_id <= 0) {
    $_SESSION['error'] = "Invalid maintenance log selected.";
    header("Location: maintenance_logs.php");
    exit();
}

// Fetch maintenance record
$stmt = $conn->prepare("
    SELECT m.*, v.plate_number, v.make, v.model, b.branch_name
    FROM maintenance_logs m
    JOIN vehicles v ON m.vehicle_id = v.id
    LEFT JOIN branches b ON v.branch_id = b.id
    WHERE m.id = ?
");
$stmt->bind_param("i", $maintenance_id);
$stmt->execute();
$result = $stmt->get_result();
if ($result->num_rows === 0) {
    $_SESSION['error'] = "Maintenance record not found.";
    header("Location: maintenance_logs.php");
    exit();
}
$data = $result->fetch_assoc();

include_once '../../includes/layout2.php';
?>

<div class="main-content p-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h4 class="fw-bold text-primary">
            <i class="fas fa-wrench me-2"></i> Maintenance Details
        </h4>
        <a href="maintenance_logs.php" class="btn btn-secondary"><i class="fas fa-arrow-left"></i> Back to Logs</a>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <h5 class="mb-3 text-dark">Vehicle: <?= htmlspecialchars($data['plate_number']) ?> - <?= htmlspecialchars($data['make'] . ' ' . $data['model']) ?></h5>
            
            <div class="row mb-2">
                <div class="col-md-6 mb-2">
                    <strong>Date:</strong> <?= htmlspecialchars($data['maintenance_date']) ?>
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Service Type:</strong> <?= htmlspecialchars($data['service_type']) ?>
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Garage Name:</strong> <?= htmlspecialchars($data['garage_name']) ?>
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Odometer Reading:</strong> <?= number_format($data['odometer'], 1) ?> km
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Cost:</strong> KES <?= number_format($data['cost'], 2) ?>
                </div>
                <div class="col-md-6 mb-2">
                    <strong>Branch:</strong> <?= htmlspecialchars($data['branch_name']) ?>
                </div>
                <div class="col-12 mt-3">
                    <strong>Remarks:</strong><br>
                    <div class="bg-light border p-3 rounded"><?= nl2br(htmlspecialchars($data['remarks'])) ?></div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include_once '../../includes/footer.php'; ?>
