<?php
session_start();
require_once '../../config/db.php';

// Redirect if not POST
if ($_SERVER["REQUEST_METHOD"] !== "POST") {
  header("Location: add.php");
  exit;
}

// CSRF Protection
if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
  die("CSRF validation failed.");
}

// Input Sanitization
$supplier_id       = (int) $_POST['supplier_id'];
$branch_id         = (int) $_POST['branch_id'];
$invoice_no        = trim($_POST['invoice_number']);
$invoice_date      = $_POST['invoice_date'];
$invoice_amount    = round((float) $_POST['total_invoice_amount'], 2);
$zero_rated        = round((float) $_POST['zero_rated_amount'], 2);
$vatable_amount    = round((float) $_POST['vatable_amount'], 2);
$vat_amount        = round((float) $_POST['vat_amount'], 2);
$withholding_tax   = round((float) $_POST['withholding_tax'], 2);
$total_with_vat    = round((float) $_POST['total_with_vat'], 2);
$total_payable     = round((float) $_POST['total_payable'], 2);
$vat_inclusion     = $_POST['vat_inclusion'] === 'inclusive' ? 'inclusive' : 'exclusive';

// Duplicate Check
$check = $conn->prepare("SELECT id FROM invoices WHERE supplier_id = ? AND invoice_number = ? LIMIT 1");
$check->bind_param("is", $supplier_id, $invoice_no);
$check->execute();
$check->store_result();
if ($check->num_rows > 0) {
  $_SESSION['error'] = "⚠️ This supplier already has an invoice with number '$invoice_no'.";
  header("Location: add.php");
  exit;
}

// File Upload Handling
$targetDir = "../../assets/uploads/invoices/";
if (!is_dir($targetDir)) {
  mkdir($targetDir, 0755, true);
}

$uploadedFile = $_FILES['invoice_file'];
$fileName     = basename($uploadedFile['name']);
$fileExt      = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

if ($fileExt !== 'pdf') {
  die("Only PDF files are allowed.");
}

$uniqueFile = uniqid('inv_', true) . '.' . $fileExt;
$targetPath = $targetDir . $uniqueFile;

if (!move_uploaded_file($uploadedFile['tmp_name'], $targetPath)) {
  die("Failed to upload invoice file.");
}

// Save Invoice to Database
$stmt = $conn->prepare("
  INSERT INTO invoices (
    supplier_id, branch_id, invoice_number, invoice_date,
    total_amount, zero_rated_amount, vatable_amount,
    vat_amount, withholding_tax, total_with_vat, total_payable,
    vat_type, file_path, status, created_at
  ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, 'Draft', NOW())
");

$stmt->bind_param(
  "iissddddddsss",
  $supplier_id, $branch_id, $invoice_no, $invoice_date,
  $invoice_amount, $zero_rated, $vatable_amount,
  $vat_amount, $withholding_tax, $total_with_vat, $total_payable,
  $vat_inclusion, $uniqueFile
);

// Execute and Send SMS if Successful
if ($stmt->execute()) {

  // ✅ SEND SMS NOTIFICATION
  $apiKey    = 'km9vP4VFDEtLoCcQMRKGdqsYrwB0jHpxO5JeA86nN1bW723T';
  $clientId  = 'DELTASTORES';
  $accessKey = 'YOUR_ACCESS_KEY_HERE'; // Replace with real access key
  $senderId  = 'DELTASTORES';
  $sms_recipient = '254705705888'; // Replace or make dynamic

  // Fetch supplier name
  $stmt2 = $conn->prepare("SELECT name FROM suppliers WHERE id = ?");
  $stmt2->bind_param("i", $supplier_id);
  $stmt2->execute();
  $stmt2->bind_result($supplier_name);
  $stmt2->fetch();
  $stmt2->close();

  // Fetch branch name (✅ correct column: branch_name)
  $stmt3 = $conn->prepare("SELECT branch_name FROM branches WHERE id = ?");
  $stmt3->bind_param("i", $branch_id);
  $stmt3->execute();
  $stmt3->bind_result($branch_name);
  $stmt3->fetch();
  $stmt3->close();

  // Construct SMS Message
  $sms_message = "NEW SUPPLIER INVOICE\nSupplier: $supplier_name\nBranch: $branch_name\nInvoice #: $invoice_no\nAmount: KES " . number_format($total_payable, 2) . "\nDate: $invoice_date";

  // Prepare Payload
  $payload = [
    "SenderId" => $senderId,
    "IsUnicode" => false,
    "IsFlash" => false,
    "ScheduleDateTime" => "",
    "MessageParameters" => [
      [
        "Number" => $sms_recipient,
        "Text" => $sms_message
      ]
    ],
    "ApiKey" => $apiKey,
    "ClientId" => $clientId
  ];

  // Send SMS via Onfon
  $ch = curl_init('https://api.onfonmedia.co.ke/v1/sms/SendBulkSMS');
  curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
  curl_setopt($ch, CURLOPT_POST, true);
  curl_setopt($ch, CURLOPT_HTTPHEADER, [
    'Content-Type: application/json',
    'AccessKey: ' . $accessKey
  ]);
  curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($payload));
  $sms_response = curl_exec($ch);
  $sms_http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
  curl_close($ch);

  // Optional: Log SMS
  error_log("📨 SMS Sent | HTTP $sms_http_code | Response: $sms_response");

  $_SESSION['success'] = "✅ Invoice saved and SMS sent!";
  header("Location: list.php");
  exit;

} else {
  die("❌ Failed to save invoice: " . $stmt->error);
}
