<?php
session_start();
require_once '../../config/db.php';

$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name ASC");

include '../../includes/layout2.php';
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-user-plus"></i> Register Merchandiser</h4>

  <form method="POST" action="save_merchandiser.php" class="card shadow-sm p-4 bg-white">
    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Full Name</label>
        <input type="text" name="full_name" class="form-control" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">ID Number</label>
        <input type="text" name="id_number" class="form-control" required>
      </div>
    </div>

    <div class="row mb-3">
      <div class="col-md-6">
        <label class="form-label">Phone Number</label>
        <input type="text" name="phone" class="form-control">
      </div>
      <div class="col-md-6">
        <label class="form-label">Supplier</label>
        <select name="supplier_id" class="form-select" required>
          <option value="">-- Select Supplier --</option>
          <?php while ($s = $suppliers->fetch_assoc()): ?>
            <option value="<?= $s['id'] ?>"><?= htmlspecialchars($s['name']) ?></option>
          <?php endwhile; ?>
        </select>
      </div>
    </div>

    <div class="mb-3">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <option value="Active" selected>Active</option>
        <option value="Inactive">Inactive</option>
      </select>
    </div>

    <div class="text-end">
      <button type="submit" class="btn btn-success"><i class="fas fa-save me-1"></i> Save</button>
      <a href="list_merchandisers.php" class="btn btn-secondary ms-2">Cancel</a>
    </div>
  </form>
</div>
