<?php
require_once '../../config/db.php';

$id_number = $_GET['id_number'] ?? '';

if (!$id_number) {
    echo json_encode(['error' => 'Missing ID number']);
    exit;
}

$stmt = $conn->prepare("SELECT id FROM merchandisers WHERE id_number = ? AND status = 'Active'");
$stmt->bind_param("s", $id_number);
$stmt->execute();
$merch = $stmt->get_result()->fetch_assoc();

if (!$merch) {
    echo json_encode(['logged_in' => false, 'error' => 'Merchandiser not found']);
    exit;
}

$stmt = $conn->prepare("SELECT log_type, branch_id FROM merchandiser_logs WHERE merchandiser_id = ? ORDER BY log_time DESC LIMIT 1");
$stmt->bind_param("i", $merch['id']);
$stmt->execute();
$last = $stmt->get_result()->fetch_assoc();

if ($last && $last['log_type'] === 'IN') {
    // Get branch name
    $stmt = $conn->prepare("SELECT branch_name FROM branches WHERE id = ?");
    $stmt->bind_param("i", $last['branch_id']);
    $stmt->execute();
    $branch = $stmt->get_result()->fetch_assoc();

    echo json_encode([
        'logged_in' => true,
        'branch_id' => $last['branch_id'],
        'branch_name' => $branch['branch_name'] ?? 'Unknown'
    ]);
} else {
    echo json_encode(['logged_in' => false]);
}
exit;
