<?php
require_once '../../config/db.php';

$log_id = $_GET['log_id'] ?? 0;
if (!$log_id || !is_numeric($log_id)) {
    exit("Invalid log ID.");
}

$stmt = $conn->prepare("
    SELECT l.log_time, l.log_type, b.branch_name, m.full_name, s.name AS supplier_name
    FROM merchandiser_logs l
    JOIN merchandisers m ON l.merchandiser_id = m.id
    JOIN suppliers s ON m.supplier_id = s.id
    JOIN branches b ON l.branch_id = b.id
    WHERE l.id = ?
");
$stmt->bind_param("i", $log_id);
$stmt->execute();
$data = $stmt->get_result()->fetch_assoc();

if (!$data) {
    exit("Log not found.");
}

$qr_content = urlencode("LogID: {$log_id}, Name: {$data['full_name']}, Time: {$data['log_time']}");
$qr_url = "https://chart.googleapis.com/chart?chs=150x150&cht=qr&chl=$qr_content";

$logo_path = '../../assets/company_logo.png';
$logo_base64 = file_exists($logo_path) ? 'data:image/png;base64,' . base64_encode(file_get_contents($logo_path)) : '';
?>

<!DOCTYPE html>
<html>
<head>
    <title>Merchandiser Badge</title>
    <meta charset="utf-8">
    <style>
        @media print {
            @page { size: 80mm auto; margin: 0; }
            body { margin: 0; padding: 0; }
        }
        body {
            width: 80mm;
            margin: 0 auto;
            font-family: Arial, sans-serif;
            font-size: 14px;
            background: #fff;
            text-align: center;
        }
        .badge-box {
            padding: 15px;
            border: 3px solid #000;
            border-radius: 10px;
            box-sizing: border-box;
        }
        .badge-box img.logo {
            width: 70px;
            height: auto;
            margin-bottom: 8px;
        }
        .badge-box h2 {
            font-size: 18px;
            margin: 8px 0;
            color: #000;
            font-weight: 800;
        }
        .badge-box p {
            margin: 4px 0;
            font-size: 15px;
            font-weight: 700;
        }
        .label {
            font-weight: 900;
            font-size: 14px;
            color: #111;
            text-transform: uppercase;
        }
        .status {
            font-weight: 900;
            font-size: 16px;
            color: <?= $data['log_type'] === 'IN' ? 'green' : 'red' ?>;
        }
        .qr-code {
            margin-top: 12px;
        }
        .footer {
            font-size: 11px;
            margin-top: 10px;
            color: #333;
        }
    </style>
</head>
<body onload="window.print(); setTimeout(() => window.close(), 1000);">

    <div class="badge-box">
        <?php if ($logo_base64): ?>
            <img src="<?= $logo_base64 ?>" class="logo" alt="Company Logo">
        <?php else: ?>
            <h2>SMARTPAY360</h2>
        <?php endif; ?>

        <h2>MERCHANDISER BADGE</h2>

        <p class="label">Name</p>
        <p><?= strtoupper(htmlspecialchars($data['full_name'])) ?></p>

        <p class="label">Supplier</p>
        <p><?= strtoupper(htmlspecialchars($data['supplier_name'])) ?></p>

        <p class="label">Branch</p>
        <p><?= strtoupper(htmlspecialchars($data['branch_name'])) ?></p>

        <p class="label">Status</p>
        <p class="status"><?= strtoupper($data['log_type']) ?></p>

        <p class="label">Time</p>
        <p><?= date('d M Y H:i:s', strtotime($data['log_time'])) ?></p>

        <div class="qr-code">
            <img src="<?= $qr_url ?>" alt="QR Code">
            <p style="font-size: 11px;">Scan to verify</p>
        </div>

        <div class="footer">
            SmartPay360 System &copy; <?= date('Y') ?>
        </div>
    </div>

</body>
</html>
