<?php
session_start();
require_once __DIR__ . '/../../config/db.php';
include __DIR__ . '/../../includes/layout2.php';
?>

<div class="main-content">
  <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-hand-holding-usd"></i> Add Newspaper Collection</h4>

  <form method="POST" action="save_collection.php" class="card p-4 shadow-sm bg-white">
    <div class="row mb-3">
      <div class="col-md-4">
        <label class="form-label">Dispatch ID</label>
        <input type="number" name="dispatch_id" class="form-control" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Quantity Collected</label>
        <input type="number" name="quantity_collected" class="form-control" required>
      </div>
      <div class="col-md-4">
        <label class="form-label">Amount Paid</label>
        <input type="number" step="0.01" name="amount_paid" class="form-control" required>
      </div>
    </div>

    <div class="mb-3">
      <label class="form-label">Payment Method</label>
      <select name="payment_method" class="form-select" required>
        <option value="">-- Select Method --</option>
        <option value="Cash">Cash</option>
        <option value="MPESA">MPESA</option>
        <option value="Credit">Credit</option>
      </select>
    </div>

    <div class="text-end">
      <button type="submit" class="btn btn-primary"><i class="fas fa-save me-1"></i> Save Collection</button>
    </div>
  </form>
</div>

<?php include __DIR__ . '/../../includes/footer.php'; ?>
