<?php
require_once '../../config/db.php';
require_once '../../vendor/autoload.php';

use Mpdf\Mpdf;

$supplier_id = isset($_GET['supplier_id']) ? (int)$_GET['supplier_id'] : 0;
$from_date = $_GET['from_date'] ?? '';
$to_date = $_GET['to_date'] ?? '';

$conditions = [];
$params = [];
$types = '';

if ($supplier_id > 0) {
    $conditions[] = "p.supplier_id = ?";
    $params[] = $supplier_id;
    $types .= 'i';
}
if (!empty($from_date)) {
    $conditions[] = "p.payment_date >= ?";
    $params[] = $from_date;
    $types .= 's';
}
if (!empty($to_date)) {
    $conditions[] = "p.payment_date <= ?";
    $params[] = $to_date;
    $types .= 's';
}
$where = count($conditions) ? 'WHERE ' . implode(' AND ', $conditions) : '';

// Query
$query = "
    SELECT p.id, s.name AS supplier_name, p.payment_date, p.amount,
    (SELECT GROUP_CONCAT(i.invoice_number ORDER BY i.invoice_number SEPARATOR ', ')
     FROM payment_allocations pa
     JOIN invoices i ON pa.invoice_id = i.id
     WHERE pa.payment_id = p.id) AS invoice_numbers
    FROM payments p
    JOIN suppliers s ON p.supplier_id = s.id
    $where
    ORDER BY p.payment_date DESC
";

$stmt = $conn->prepare($query);
if (count($params)) {
    $stmt->bind_param($types, ...$params);
}
$stmt->execute();
$result = $stmt->get_result();

$html = '
<h4 style="text-align:center;">Supplier Payments Report</h4>
<table border="1" cellpadding="6" cellspacing="0" width="100%">
    <thead>
        <tr style="background-color:#f2f2f2;">
            <th>#</th>
            <th>Supplier</th>
            <th>Payment Date</th>
            <th>Amount</th>
            <th>Invoice No(s)</th>
        </tr>
    </thead>
    <tbody>';

$i = 1;
while ($row = $result->fetch_assoc()) {
    $html .= '<tr>
        <td>' . $i++ . '</td>
        <td>' . htmlspecialchars($row['supplier_name']) . '</td>
        <td>' . date('d-M-Y', strtotime($row['payment_date'])) . '</td>
        <td style="text-align:right;">KSh ' . number_format($row['amount'], 2) . '</td>
        <td>' . htmlspecialchars($row['invoice_numbers'] ?: 'None') . '</td>
    </tr>';
}

$html .= '</tbody></table>';

$mpdf = new Mpdf(['orientation' => 'L']);
$mpdf->WriteHTML($html);
$mpdf->Output('supplier_payments_' . date('Ymd_His') . '.pdf', 'D');
exit;
