<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

if (!isset($_SESSION['username'])) {
    header("Location: ../../login.php");
    exit();
}

$current_user = $_SESSION['username'];
$form_data = $_SESSION['form_data'] ?? [];
unset($_SESSION['form_data']);

// Fetch branches
$branch_result = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name ASC");

// Fetch suppliers
$supplier_result = $conn->query("SELECT id, name FROM suppliers ORDER BY name ASC");

// Fetch expense types grouped by category
$expense_types = [];
$exp_result = $conn->query("SELECT * FROM expense_types WHERE status = 'Active' ORDER BY category, name ASC");
if ($exp_result) {
    while ($row = $exp_result->fetch_assoc()) {
        $expense_types[$row['category']][] = $row;
    }
} else {
    die("Error loading expense types: " . $conn->error);
}
?>

<div class="main-content">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h4 class="fw-bold text-primary mb-0"><i class="fas fa-wallet me-2"></i> Add Petty Cash Transaction</h4>
    </div>

    <?php if (isset($_SESSION['error'])): ?>
        <div class="alert alert-danger alert-dismissible fade show" role="alert">
            <?= $_SESSION['error'] ?>
            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
        </div>
    <?php unset($_SESSION['error']); endif; ?>

    <form id="pettyCashForm" action="save_transaction.php" method="POST" class="needs-validation" novalidate>
        <input type="hidden" name="csrf_token" value="<?= $_SESSION['csrf_token'] ?? '' ?>">
        <input type="hidden" name="reference_no" value="">
        <input type="hidden" name="print_password" id="hidden_password" value="">

        <div class="card shadow border-0">
            <div class="card-body">
                <div class="row g-4">
                    <div class="col-md-6">
                        <label for="branch_id" class="form-label">Branch <span class="text-danger">*</span></label>
                        <select name="branch_id" id="branch_id" class="form-select" required>
                            <option value="">Select Branch</option>
                            <?php while ($branch = $branch_result->fetch_assoc()): ?>
                                <option value="<?= $branch['id'] ?>" <?= ($form_data['branch_id'] ?? '') == $branch['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($branch['branch_name']) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label for="type" class="form-label">Type <span class="text-danger">*</span></label>
                        <select name="type" id="type" class="form-select" required>
                            <option value="">Select Type</option>
                            <option value="payout" <?= ($form_data['type'] ?? '') === 'payout' ? 'selected' : '' ?>>Expense / Purchase</option>
                            <option value="receipt" <?= ($form_data['type'] ?? '') === 'receipt' ? 'selected' : '' ?>>Receipt</option>
                            <option value="reimbursement" <?= ($form_data['type'] ?? '') === 'reimbursement' ? 'selected' : '' ?>>Reimbursement</option>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label for="expense_type_id" class="form-label">Expense Type <span class="text-danger">*</span></label>
                        <select name="expense_type_id" id="expense_type_id" class="form-select" required>
                            <option value="">Select Expense Type</option>
                            <?php foreach ($expense_types as $category => $items): ?>
                                <optgroup label="<?= htmlspecialchars($category) ?>">
                                    <?php foreach ($items as $item): ?>
                                        <option value="<?= $item['id'] ?>" <?= ($form_data['expense_type_id'] ?? '') == $item['id'] ? 'selected' : '' ?>>
                                            <?= htmlspecialchars($item['name']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </optgroup>
                            <?php endforeach; ?>
                        </select>
                    </div>

                    <div class="col-md-6">
                        <label for="amount" class="form-label">Amount (KSh) <span class="text-danger">*</span></label>
                        <div class="input-group">
                            <span class="input-group-text">KSh</span>
                            <input type="number" name="amount" id="amount" class="form-control" step="0.01" min="0" required
                                value="<?= htmlspecialchars($form_data['amount'] ?? '') ?>">
                        </div>
                    </div>

                    <div class="col-md-6">
                        <label for="transaction_date" class="form-label">Date <span class="text-danger">*</span></label>
                        <input type="date" name="transaction_date" id="transaction_date" class="form-control" required
                            value="<?= htmlspecialchars($form_data['transaction_date'] ?? date('Y-m-d')) ?>">
                    </div>

                    <div class="col-md-6">
                        <label for="supplier_id" class="form-label">Supplier (Optional)</label>
                        <select name="supplier_id" id="supplier_id" class="form-select">
                            <option value="">None</option>
                            <?php while ($supplier = $supplier_result->fetch_assoc()): ?>
                                <option value="<?= $supplier['id'] ?>" <?= ($form_data['supplier_id'] ?? '') == $supplier['id'] ? 'selected' : '' ?>>
                                    <?= htmlspecialchars($supplier['name']) ?>
                                </option>
                            <?php endwhile; ?>
                        </select>
                    </div>

                    <div class="col-md-6" id="payee_name_wrapper" style="<?= empty($form_data['supplier_id']) ? 'display:block' : 'display:none' ?>">
                        <label for="payee_name" class="form-label">Payee Name (if no supplier)</label>
                        <input type="text" name="payee_name" id="payee_name" class="form-control"
                            value="<?= htmlspecialchars($form_data['payee_name'] ?? '') ?>">
                    </div>

                    <div class="col-md-6">
                        <label for="collected_by" class="form-label">Person Collecting Cash <span class="text-danger">*</span></label>
                        <input type="text" name="collected_by" id="collected_by" class="form-control" required
                            value="<?= htmlspecialchars($form_data['collected_by'] ?? '') ?>">
                    </div>

                    <div class="col-12">
                        <label for="description" class="form-label">Description <span class="text-danger">*</span></label>
                        <textarea name="description" id="description" class="form-control" rows="4" required><?= htmlspecialchars($form_data['description'] ?? '') ?></textarea>
                    </div>
                </div>

                <div class="mt-4 d-flex justify-content-between">
                    <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#confirmModal">
                        <i class="fas fa-save me-1"></i> Save Transaction
                    </button>
                    <a href="list.php" class="btn btn-outline-secondary"><i class="fas fa-times me-1"></i> Cancel</a>
                </div>
            </div>
        </div>
    </form>
</div>

<!-- Confirmation Modal -->
<div class="modal fade" id="confirmModal" tabindex="-1" aria-labelledby="confirmModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content border-0 shadow">
            <div class="modal-header bg-primary text-white">
                <h5 class="modal-title" id="confirmModalLabel"><i class="fas fa-lock me-2"></i> Confirm Print Access</h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <p>Please confirm your identity to proceed:</p>
                <div class="mb-3">
                    <label class="form-label">Username</label>
                    <input type="text" class="form-control" value="<?= htmlspecialchars($current_user) ?>" disabled>
                </div>
                <div class="mb-3">
                    <label for="print_password" class="form-label">Password <span class="text-danger">*</span></label>
                    <input type="password" class="form-control" id="print_password_modal" required>
                    <div class="invalid-feedback">Please enter your password.</div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancel</button>
                <button id="confirmSubmit" class="btn btn-primary"><i class="fas fa-check me-1"></i> Confirm</button>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('supplier_id').addEventListener('change', function () {
    document.getElementById('payee_name_wrapper').style.display = this.value === '' ? 'block' : 'none';
});

document.getElementById('confirmSubmit').addEventListener('click', function () {
    const passInput = document.getElementById('print_password_modal');
    if (passInput.value.trim() === '') {
        passInput.classList.add('is-invalid');
    } else {
        document.getElementById('hidden_password').value = passInput.value;
        document.getElementById('pettyCashForm').submit();
    }
});

<?php if (isset($_SESSION['error']) && strpos($_SESSION['error'], 'password') !== false): ?>
window.addEventListener('DOMContentLoaded', () => {
    new bootstrap.Modal(document.getElementById('confirmModal')).show();
});
<?php endif; ?>
</script>
