<?php
session_start();
require_once '../../config/db.php';

$id = (int)($_GET['id'] ?? 0);
if ($id <= 0) {
    $_SESSION['error'] = "Invalid transaction.";
    header('Location: list.php');
    exit;
}

// Check if support document exists first
$stmt = $conn->prepare("SELECT support_doc FROM petty_cash_transactions WHERE id = ?");
$stmt->bind_param('i', $id);
$stmt->execute();
$result = $stmt->get_result();
$txn = $result->fetch_assoc();

if (!$txn) {
    $_SESSION['error'] = "Transaction not found.";
    header('Location: list.php');
    exit;
}

// If no support_doc uploaded, redirect to enter payment details
if (empty($txn['support_doc'])) {
    header("Location: enter_payment_details.php?id=$id");
    exit;
}

// Approve transaction
$update = $conn->prepare("UPDATE petty_cash_transactions SET status='approved' WHERE id = ?");
$update->bind_param('i', $id);

if ($update->execute()) {
    $_SESSION['success'] = "Transaction approved successfully.";
} else {
    $_SESSION['error'] = "Failed to approve transaction.";
}

header('Location: list.php');
exit;
?>
