<?php
session_start();
require_once '../../config/db.php'; // Adjust path as needed

header('Content-Type: application/json');
$response = ['status' => 'error', 'message' => 'Unknown error'];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    try {
        if ($action === 'fetch_promos') {
            $stmt = $conn->prepare("SELECT * FROM promotions ORDER BY start_date DESC");
            $stmt->execute();
            $result = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);
            $response = ['status' => 'success', 'data' => $result];
        } elseif ($action === 'upload_price_change') {
            $item_code = $_POST['item_code'];
            $old_price = $_POST['old_price'];
            $new_price = $_POST['new_price'];
            $stmt = $conn->prepare("INSERT INTO price_changes (item_code, old_price, new_price, created_at) VALUES (?, ?, ?, NOW())");
            $stmt->bind_param("sdd", $item_code, $old_price, $new_price);
            $stmt->execute();
            $response = ['status' => 'success', 'message' => 'Price change recorded'];
        } else {
            $response['message'] = 'Invalid action';
        }
    } catch (Exception $e) {
        $response['message'] = 'Error: ' . $e->getMessage();
    }
}

echo json_encode($response);
?>
