<?php
session_start();
require_once '../../includes/layout.php';
require_once '../../config/db.php';

$query = "SELECT * FROM promotions WHERE active = 1 ORDER BY start_date DESC";
$result = $conn->query($query);
?>

<div class="container mt-4">
    <h2 class="mb-4">Active Promotions</h2>
    <table class="table table-striped">
        <thead>
            <tr>
                <th>Promo Name</th>
                <th>Description</th>
                <th>Start Date</th>
                <th>End Date</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            <?php while ($row = $result->fetch_assoc()): ?>
                <tr>
                    <td><?= htmlspecialchars($row['promo_name']) ?></td>
                    <td><?= htmlspecialchars($row['description']) ?></td>
                    <td><?= htmlspecialchars($row['start_date']) ?></td>
                    <td><?= htmlspecialchars($row['end_date']) ?></td>
                    <td><?= $row['active'] ? 'Active' : 'Inactive' ?></td>
                </tr>
            <?php endwhile; ?>
        </tbody>
    </table>
</div>
