<?php
session_start();
require_once '../../config/db.php';

// Total promotions
$result = $conn->query("SELECT COUNT(*) AS count FROM promotions");
if (!$result) {
    die("Error in total promotions query: " . $conn->error);
}
$total_promos = $result->fetch_assoc()['count'];

// Active promotions
$result_active = $conn->query("SELECT COUNT(*) AS count FROM promotions WHERE active = 1");
if (!$result_active) {
    die("Error in active promotions query: " . $conn->error);
}
$active_promos = $result_active->fetch_assoc()['count'];
?>

<div class="container mt-4">
    <h2>Promotions Dashboard</h2>
    <div class="row">
        <div class="col-md-4">
            <div class="card text-bg-primary mb-3">
                <div class="card-body">
                    <h5 class="card-title">Total Promotions</h5>
                    <p class="card-text fs-4"><?= $total_promos ?></p>
                </div>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card text-bg-success mb-3">
                <div class="card-body">
                    <h5 class="card-title">Active Promotions</h5>
                    <p class="card-text fs-4"><?= $active_promos ?></p>
                </div>
            </div>
        </div>
    </div>
</div>
