<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

$sql = "
    SELECT l.*, p.reference_no, s.name AS supplier_name, u.username AS changed_by_user
    FROM cheque_status_logs l
    JOIN payments p ON l.payment_id = p.id
    JOIN suppliers s ON p.supplier_id = s.id
    LEFT JOIN users u ON l.changed_by = u.id
    ORDER BY l.changed_at DESC
";
$result = $conn->query($sql);
?>

<div class="container mt-4">
  <h4 class="text-primary mb-3"><i class="fas fa-history"></i> Cheque Status Logs</h4>

  <div class="table-responsive">
    <table class="table table-hover table-bordered small align-middle">
      <thead class="table-dark">
        <tr class="text-center">
          <th>#</th>
          <th>Cheque No.</th>
          <th>Supplier</th>
          <th>Old Status</th>
          <th>New Status</th>
          <th>Changed By</th>
          <th>Changed At</th>
        </tr>
      </thead>
      <tbody>
        <?php if ($result->num_rows > 0): ?>
          <?php $i = 1; while ($log = $result->fetch_assoc()): ?>
            <tr>
              <td class="text-center"><?= $i++ ?></td>
              <td><?= htmlspecialchars($log['reference_no']) ?></td>
              <td><?= htmlspecialchars($log['supplier_name']) ?></td>
              <td class="text-center">
                <span class="badge <?= badgeClass($log['old_status']) ?>"><?= $log['old_status'] ?></span>
              </td>
              <td class="text-center">
                <span class="badge <?= badgeClass($log['new_status']) ?>"><?= $log['new_status'] ?></span>
              </td>
              <td><?= htmlspecialchars($log['changed_by_user'] ?? 'System') ?></td>
              <td><?= date('d-M-Y H:i', strtotime($log['changed_at'])) ?></td>
            </tr>
          <?php endwhile; ?>
        <?php else: ?>
          <tr><td colspan="7" class="text-center text-muted">No status changes recorded yet.</td></tr>
        <?php endif; ?>
      </tbody>
    </table>
  </div>
</div>

<?php
// Helper for badge color
function badgeClass($status) {
  return match ($status) {
    'Cleared'   => 'bg-success',
    'Bounced'   => 'bg-danger',
    'Cancelled' => 'bg-dark',
    default     => 'bg-warning text-dark'
  };
}
?>
