
<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';


// Initialize filters
$start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-30 days'));
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$bank_id = isset($_GET['bank_id']) ? (int)$_GET['bank_id'] : 0;
$status = $_GET['status'] ?? '';

// Fetch banks for filter
$banks = $conn->query("SELECT id, bank_name FROM banks ORDER BY bank_name")->fetch_all(MYSQLI_ASSOC);

// Build query
$query = "
    SELECT c.cheque_no, c.payee, c.amount, c.cheque_date, c.status, b.bank_name, p.reference_no
    FROM cheques c
    JOIN banks b ON c.bank_id = b.id
    LEFT JOIN payments p ON c.payment_id = p.id
    WHERE c.cheque_date BETWEEN ? AND ?
";
$params = [$start_date, $end_date];
$types = "ss";

if ($bank_id > 0) {
    $query .= " AND c.bank_id = ?";
    $params[] = $bank_id;
    $types .= "i";
}
if ($status) {
    $query .= " AND c.status = ?";
    $params[] = $status;
    $types .= "s";
}
$query .= " ORDER BY c.cheque_date DESC";

$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
$report_data = $result->fetch_all(MYSQLI_ASSOC);
?>

<div class="main-content">
    <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-money-check-alt me-2"></i>Cheque Status Report</h4>

    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Start Date</label>
                    <input type="date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">End Date</label>
                    <input type="date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Bank</label>
                    <select name="bank_id" class="form-select">
                        <option value="0">All Banks</option>
                        <?php foreach ($banks as $b): ?>
                            <option value="<?= $b['id'] ?>" <?= $b['id'] == $bank_id ? 'selected' : '' ?>>
                                <?= htmlspecialchars($b['bank_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Status</label>
                    <select name="status" class="form-select">
                        <option value="">All Statuses</option>
                        <option value="Issued" <?= $status == 'Issued' ? 'selected' : '' ?>>Issued</option>
                        <option value="Cleared" <?= $status == 'Cleared' ? 'selected' : '' ?>>Cleared</option>
                        <option value="Cancelled" <?= $status == 'Cancelled' ? 'selected' : '' ?>>Cancelled</option>
                        <option value="Returned" <?= $status == 'Returned' ? 'selected' : '' ?>>Returned</option>
                        <option value="Stopped" <?= $status == 'Stopped' ? 'selected' : '' ?>>Stopped</option>
                    </select>
                </div>
                <div class="col-md-12 text-end">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-1"></i>Apply Filters</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Report Table -->
    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-dark">
                    <tr class="text-center">
                        <th>Cheque No</th>
                        <th>Payee</th>
                        <th>Bank</th>
                        <th>Payment Ref</th>
                        <th>Cheque Date</th>
                        <th>Amount (KES)</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($report_data): ?>
                        <?php foreach ($report_data as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['cheque_no']) ?></td>
                                <td><?= htmlspecialchars($row['payee']) ?></td>
                                <td><?= htmlspecialchars($row['bank_name']) ?></td>
                                <td><?= htmlspecialchars($row['reference_no'] ?: 'N/A') ?></td>
                                <td class="text-center"><?= date('d-M-Y', strtotime($row['cheque_date'])) ?></td>
                                <td class="text-end">KSh <?= number_format($row['amount'], 2) ?></td>
                                <td class="text-center"><?= htmlspecialchars($row['status']) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="7" class="text-center text-muted">No cheques found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>