
<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';


// Initialize filters
$start_date = $_GET['start_date'] ?? date('Y-m-d', strtotime('-30 days'));
$end_date = $_GET['end_date'] ?? date('Y-m-d');
$supplier_id = isset($_GET['supplier_id']) ? (int)$_GET['supplier_id'] : 0;
$branch_id = isset($_GET['branch_id']) ? (int)$_GET['branch_id'] : 0;

// Fetch suppliers and branches for filters
$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name")->fetch_all(MYSQLI_ASSOC);
$branches = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name")->fetch_all(MYSQLI_ASSOC);

// Build query
$query = "
    SELECT i.status, COUNT(i.id) AS invoice_count, SUM(i.total_payable) AS total_amount
    FROM invoices i
    JOIN suppliers s ON i.supplier_id = s.id
    JOIN branches b ON i.branch_id = b.id
    WHERE i.invoice_date BETWEEN ? AND ?
";
$params = [$start_date, $end_date];
$types = "ss";

if ($supplier_id > 0) {
    $query .= " AND i.supplier_id = ?";
    $params[] = $supplier_id;
    $types .= "i";
}
if ($branch_id > 0) {
    $query .= " AND i.branch_id = ?";
    $params[] = $branch_id;
    $types .= "i";
}
$query .= " GROUP BY i.status ORDER BY i.status";

$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
$report_data = $result->fetch_all(MYSQLI_ASSOC);
?>

<div class="main-content">
    <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-chart-pie me-2"></i>Invoices by Status</h4>

    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Start Date</label>
                    <input type="date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">End Date</label>
                    <input type="date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Supplier</label>
                    <select name="supplier_id" class="form-select">
                        <option value="0">All Suppliers</option>
                        <?php foreach ($suppliers as $s): ?>
                            <option value="<?= $s['id'] ?>" <?= $s['id'] == $supplier_id ? 'selected' : '' ?>>
                                <?= htmlspecialchars($s['name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Branch</label>
                    <select name="branch_id" class="form-select">
                        <option value="0">All Branches</option>
                        <?php foreach ($branches as $b): ?>
                            <option value="<?= $b['id'] ?>" <?= $b['id'] == $branch_id ? 'selected' : '' ?>>
                                <?= htmlspecialchars($b['branch_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-12 text-end">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-1"></i>Apply Filters</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Report Table -->
    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-dark">
                    <tr class="text-center">
                        <th>Status</th>
                        <th>Invoice Count</th>
                        <th>Total Amount (KES)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($report_data): ?>
                        <?php foreach ($report_data as $row): ?>
                            <tr>
                                <td><?= htmlspecialchars($row['status']) ?></td>
                                <td class="text-center"><?= $row['invoice_count'] ?></td>
                                <td class="text-end">KSh <?= number_format($row['total_amount'], 2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="3" class="text-center text-muted">No data found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>