
<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Initialize filters
$due_start_date = $_GET['due_start_date'] ?? date('Y-m-d', strtotime('-90 days'));
$due_end_date = $_GET['due_end_date'] ?? date('Y-m-d');
$supplier_id = isset($_GET['supplier_id']) ? (int)$_GET['supplier_id'] : 0;
$branch_id = isset($_GET['branch_id']) ? (int)$_GET['branch_id'] : 0;

// Assume due_date is invoice_date + 30 days if no due_date column
$suppliers = $conn->query("SELECT id, name FROM suppliers ORDER BY name")->fetch_all(MYSQLI_ASSOC);
$branches = $conn->query("SELECT id, branch_name FROM branches ORDER BY branch_name")->fetch_all(MYSQLI_ASSOC);

// Build query
$query = "
    SELECT i.id, i.invoice_number, s.name AS supplier_name, b.branch_name, 
           i.invoice_date, i.total_payable,
           IFNULL(SUM(pa.amount_allocated), 0) AS total_paid,
           IFNULL(SUM(cn.amount), 0) AS total_credit
    FROM invoices i
    JOIN suppliers s ON i.supplier_id = s.id
    JOIN branches b ON i.branch_id = b.id
    LEFT JOIN payment_allocations pa ON i.id = pa.invoice_id
    LEFT JOIN credit_notes cn ON i.id = cn.invoice_id
    WHERE DATE_ADD(i.invoice_date, INTERVAL 30 DAY) BETWEEN ? AND ?
      AND i.status != 'Paid'
    GROUP BY i.id
    HAVING (total_payable - total_paid - total_credit) > 0
";
$params = [$due_start_date, $due_end_date];
$types = "ss";

if ($supplier_id > 0) {
    $query .= " AND i.supplier_id = ?";
    $params[] = $supplier_id;
    $types .= "i";
}
if ($branch_id > 0) {
    $query .= " AND i.branch_id = ?";
    $params[] = $branch_id;
    $types .= "i";
}
$query .= " ORDER BY i.invoice_date";

$stmt = $conn->prepare($query);
$stmt->bind_param($types, ...$params);
$stmt->execute();
$result = $stmt->get_result();
$report_data = $result->fetch_all(MYSQLI_ASSOC);
?>

<div class="main-content">
    <h4 class="fw-bold mb-4 text-primary"><i class="fas fa-exclamation-triangle me-2"></i>Overdue Invoices</h4>

    <!-- Filters -->
    <div class="card shadow-sm mb-4">
        <div class="card-body">
            <form method="GET" class="row g-3">
                <div class="col-md-3">
                    <label class="form-label">Due Start Date</label>
                    <input type="date" name="due_start_date" value="<?= htmlspecialchars($due_start_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Due End Date</label>
                    <input type="date" name="due_end_date" value="<?= htmlspecialchars($due_end_date) ?>" class="form-control" required>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Supplier</label>
                    <select name="supplier_id" class="form-select">
                        <option value="0">All Suppliers</option>
                        <?php foreach ($suppliers as $s): ?>
                            <option value="<?= $s['id'] ?>" <?= $s['id'] == $supplier_id ? 'selected' : '' ?>>
                                <?= htmlspecialchars($s['name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-3">
                    <label class="form-label">Branch</label>
                    <select name="branch_id" class="form-select">
                        <option value="0">All Branches</option>
                        <?php foreach ($branches as $b): ?>
                            <option value="<?= $b['id'] ?>" <?= $b['id'] == $branch_id ? 'selected' : '' ?>>
                                <?= htmlspecialchars($b['branch_name']) ?>
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="col-md-12 text-end">
                    <button type="submit" class="btn btn-primary"><i class="fas fa-filter me-1"></i>Apply Filters</button>
                </div>
            </form>
        </div>
    </div>

    <!-- Report Table -->
    <div class="card shadow-sm">
        <div class="card-body table-responsive">
            <table class="table table-hover table-bordered align-middle">
                <thead class="table-dark">
                    <tr class="text-center">
                        <th>Invoice No</th>
                        <th>Supplier</th>
                        <th>Branch</th>
                        <th>Invoice Date</th>
                        <th>Due Date</th>
                        <th>Total Payable (KES)</th>
                        <th>Outstanding (KES)</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if ($report_data): ?>
                        <?php foreach ($report_data as $row): ?>
                            <?php $outstanding = $row['total_payable'] - $row['total_paid'] - $row['total_credit']; ?>
                            <tr>
                                <td><a href="../invoices/view.php?id=<?= $row['id'] ?>" class="text-primary"><?= htmlspecialchars($row['invoice_number']) ?></a></td>
                                <td><?= htmlspecialchars($row['supplier_name']) ?></td>
                                <td><?= htmlspecialchars($row['branch_name']) ?></td>
                                <td class="text-center"><?= date('d-M-Y', strtotime($row['invoice_date'])) ?></td>
                                <td class="text-center"><?= date('d-M-Y', strtotime($row['invoice_date'] . ' +30 days')) ?></td>
                                <td class="text-end">KSh <?= number_format($row['total_payable'], 2) ?></td>
                                <td class="text-end text-danger">KSh <?= number_format($outstanding, 2) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <tr><td colspan="7" class="text-center text-muted">No overdue invoices found.</td></tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>