<?php
session_start();
require_once '../../config/db.php';

if (!isset($_GET['supplier_id'])) die("Supplier not specified.");
$supplier_id = (int) $_GET['supplier_id'];

// Fetch supplier info
$supplier = $conn->query("SELECT * FROM suppliers WHERE id = $supplier_id")->fetch_assoc();
if (!$supplier) die("Supplier not found.");

// Fetch combined invoices (debits) and payments (credits)
$ledger = $conn->query("
  SELECT 'invoice' AS type, invoice_date AS date, invoice_number AS reference, total_payable AS amount, NULL AS payment_ref
  FROM invoices
  WHERE supplier_id = $supplier_id AND status IN ('Approved', 'Paid')
  UNION
  SELECT 'payment' AS type, payment_date AS date, NULL AS reference, amount AS amount, payment_reference
  FROM payments
  WHERE supplier_id = $supplier_id
  ORDER BY date ASC
");
?>

<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <title>Supplier Statement - <?= htmlspecialchars($supplier['name']) ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    @media print {
      .no-print { display: none; }
    }
    body {
      padding: 40px;
      font-family: 'Segoe UI', sans-serif;
    }
    h2, h5 {
      margin-bottom: 0.5rem;
    }
    table th, table td {
      font-size: 14px;
      vertical-align: middle;
    }
  </style>
</head>
<body>

<div class="mb-4">
  <h2>Supplier Statement</h2>
  <h5><?= htmlspecialchars($supplier['name']) ?></h5>
  <small>KRA PIN: <?= htmlspecialchars($supplier['kra_pin']) ?></small><br>
  <small>Phone: <?= htmlspecialchars($supplier['phone']) ?> | Email: <?= htmlspecialchars($supplier['email']) ?></small>
</div>

<table class="table table-bordered">
  <thead class="table-light">
    <tr>
      <th>#</th>
      <th>Date</th>
      <th>Description</th>
      <th>Ref</th>
      <th class="text-end">Debit (KSh)</th>
      <th class="text-end">Credit (KSh)</th>
      <th class="text-end">Balance (KSh)</th>
    </tr>
  </thead>
  <tbody>
    <?php
    $n = 1;
    $balance = 0;
    $total_debit = 0;
    $total_credit = 0;

    if ($ledger->num_rows > 0):
      while ($row = $ledger->fetch_assoc()):
        $date = date('d-M-Y', strtotime($row['date']));
        $desc = ($row['type'] === 'invoice') ? 'Invoice' : 'Payment';
        $ref = $row['type'] === 'invoice' ? $row['reference'] : $row['payment_ref'];

        if ($row['type'] === 'invoice') {
          $debit = $row['amount'];
          $credit = 0;
          $total_debit += $debit;
        } else {
          $credit = $row['amount'];
          $debit = 0;
          $total_credit += $credit;
        }

        $balance += ($debit - $credit);
    ?>
      <tr>
        <td><?= $n++ ?></td>
        <td><?= $date ?></td>
        <td><?= $desc ?></td>
        <td><?= $ref ?? '-' ?></td>
        <td class="text-end"><?= $debit ? number_format($debit, 2) : '' ?></td>
        <td class="text-end"><?= $credit ? number_format($credit, 2) : '' ?></td>
        <td class="text-end fw-bold"><?= number_format($balance, 2) ?></td>
      </tr>
    <?php endwhile; else: ?>
      <tr><td colspan="7" class="text-center text-muted">No transactions found.</td></tr>
    <?php endif; ?>
  </tbody>
  <tfoot>
    <tr>
      <th colspan="4" class="text-end">Totals</th>
      <th class="text-end">KSh <?= number_format($total_debit, 2) ?></th>
      <th class="text-end">KSh <?= number_format($total_credit, 2) ?></th>
      <th class="text-end text-primary">KSh <?= number_format($balance, 2) ?></th>
    </tr>
  </tfoot>
</table>

<div class="text-end mt-4 no-print">
  <button class="btn btn-primary" onclick="window.print()"><i class="fas fa-print me-1"></i> Print</button>
  <a href="../suppliers/view.php?id=<?= $supplier_id ?>" class="btn btn-secondary">Back</a>
</div>

</body>
</html>
