<?php
session_start();
require_once '../../config/db.php';

function back($id,$msg=null){ if($msg) $_SESSION['error']=$msg; header('Location: view.php?id='.$id); exit; }
if (($_POST['csrf_token'] ?? '') !== ($_SESSION['csrf_token'] ?? '')) back((int)($_POST['credit_note_id']??0),'Invalid session token.');

$cn_id = (int)($_POST['credit_note_id'] ?? 0);
$invoice_ids = $_POST['invoice_id'] ?? [];
$alloc_amounts = $_POST['alloc_amount'] ?? [];
$user_id = (int)($_SESSION['user_id'] ?? 0);

if (!$cn_id || !count($invoice_ids)) back($cn_id,'Nothing to allocate.');

$hdr = $conn->query("SELECT note_type, status, supplier_id FROM supplier_credit_notes WHERE id={$cn_id}")->fetch_assoc();
if (!$hdr || $hdr['note_type']!=='Credit Note') back($cn_id,'Not a Supplier Credit Note.');
if ($hdr['status']!=='active') back($cn_id,'Credit Note not active.');

$conn->begin_transaction();
try {
  $row = $conn->query("SELECT available FROM v_supplier_credit_available WHERE credit_note_id={$cn_id}")->fetch_assoc();
  $available = (float)($row['available'] ?? 0);

  $sum=0; $pairs=[];
  for($i=0;$i<count($invoice_ids);$i++){
    $inv=(int)$invoice_ids[$i]; $amt=(float)$alloc_amounts[$i];
    if($amt<=0) continue;

    $q = $conn->prepare("
      SELECT i.id, i.supplier_id, i.total_amount,
             (i.total_amount - COALESCE(a.alloc_sum,0)) AS balance
      FROM invoices i
      LEFT JOIN (
        SELECT invoice_id, SUM(allocated_amount) AS alloc_sum
        FROM supplier_credit_allocations GROUP BY invoice_id
      ) a ON a.invoice_id = i.id
      WHERE i.id = ? LIMIT 1
    ");
    $q->bind_param('i',$inv); $q->execute(); $iv = $q->get_result()->fetch_assoc(); $q->close();

    if (!$iv) throw new Exception("Invoice #{$inv} not found.");
    if ((int)$iv['supplier_id'] !== (int)$hdr['supplier_id']) throw new Exception("Invoice #{$inv} supplier mismatch.");
    if ($amt > ((float)$iv['balance'] + 0.001)) throw new Exception("Allocation exceeds balance for invoice #{$inv}.");

    $pairs[]=['inv'=>$inv,'amt'=>$amt]; $sum += $amt;
  }
  if ($sum<=0) throw new Exception('No positive amounts.');
  if ($sum>$available+0.001) throw new Exception('Allocation exceeds credit available.');

  $st=$conn->prepare("INSERT INTO supplier_credit_allocations (credit_note_id, invoice_id, allocated_amount, created_by) VALUES (?,?,?,?)");
  foreach($pairs as $p){ $st->bind_param('iidi',$cn_id,$p['inv'],$p['amt'],$user_id); if(!$st->execute()) throw new Exception($st->error); }
  $st->close();

  $conn->commit();
  $_SESSION['success']='Allocation saved.';
  header('Location: view.php?id='.$cn_id); exit;

} catch(Throwable $e){
  $conn->rollback();
  back($cn_id,'Failed to allocate: '.$e->getMessage());
}
