<?php
session_start();
require_once '../../config/db.php';

function back($id,$msg=null){ if($msg) $_SESSION['error']=$msg; header('Location: view.php?id='.$id); exit; }
if (($_POST['csrf_token'] ?? '') !== ($_SESSION['csrf_token'] ?? '')) back((int)($_POST['credit_note_id']??0),'Invalid session.');

$cn_id = (int)($_POST['credit_note_id'] ?? 0);
$grn_ids = $_POST['grn_id'] ?? [];
$match_amounts = $_POST['match_amount'] ?? [];
$user_id = (int)($_SESSION['user_id'] ?? 0);
if (!$cn_id) back($cn_id,'Missing document.');

$hdr = $conn->query("SELECT id, supplier_id, status, note_type FROM supplier_credit_notes WHERE id={$cn_id}")->fetch_assoc();
if (!$hdr || $hdr['note_type']!=='Credit Note') back($cn_id,'Not a supplier credit note.');
if ($hdr['status']!=='active') back($cn_id,'Credit note is not active.');
$scn_supplier = (int)$hdr['supplier_id'];

$a = $conn->query("SELECT available FROM v_supplier_credit_available WHERE credit_note_id={$cn_id}")->fetch_assoc();
$scn_available = (float)($a['available'] ?? 0);

$rows=[]; $sum=0.0;
for($i=0;$i<count($grn_ids);$i++){
  $gid = (int)$grn_ids[$i];
  $amt = (float)$match_amounts[$i];
  if ($gid<=0 || $amt<=0) continue;

  $g = $conn->prepare("SELECT grn_id, supplier_id, status, available FROM v_supplier_grn_available WHERE grn_id=? LIMIT 1");
  $g->bind_param('i',$gid); $g->execute();
  $row = $g->get_result()->fetch_assoc(); $g->close();

  if (!$row) back($cn_id,"GRN #{$gid} not found.");
  if ($row['status']!=='active') back($cn_id,"GRN #{$gid} is not active.");
  if ((int)$row['supplier_id'] !== $scn_supplier) back($cn_id,"Supplier mismatch on GRN #{$gid}.");
  if ($amt > (float)$row['available'] + 0.001) back($cn_id,"Amount exceeds GRN #{$gid} available.");

  $rows[]=['gid'=>$gid,'amt'=>$amt];
  $sum += $amt;
}
if ($sum<=0) back($cn_id,'Enter at least one positive match amount.');
if ($sum > $scn_available + 0.001) back($cn_id,'Total matches exceed credit available.');

$conn->begin_transaction();
try {
  $ins = $conn->prepare("INSERT INTO supplier_grn_matches (credit_note_id, grn_id, matched_amount, created_by) VALUES (?,?,?,?)");
  foreach($rows as $r){
    $ins->bind_param('iidi', $cn_id, $r['gid'], $r['amt'], $user_id);
    if(!$ins->execute()) throw new Exception($ins->error);
  }
  $ins->close();

  $conn->commit();
  $_SESSION['success']='GRNs matched successfully.';
  header('Location: view.php?id='.$cn_id); exit;

} catch(Throwable $e){
  $conn->rollback();
  back($cn_id,'Failed to save matches: '.$e->getMessage());
}
