<?php
session_start();
require_once '../../config/db.php';
include '../../includes/layout2.php';

// Handle search filter
$search = $_GET['q'] ?? '';
$sql = "SELECT * FROM suppliers";
if (!empty($search)) {
  $q = $conn->real_escape_string($search);
  $sql .= " WHERE name LIKE '%$q%' OR kra_pin LIKE '%$q%'";
}
$sql .= " ORDER BY name ASC";
$result = $conn->query($sql);
?>

<div class="main-content">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h5 class="fw-bold text-primary mb-0"><i class="fas fa-truck"></i> Supplier List</h5>
    <a href="add.php" class="btn btn-sm btn-primary"><i class="fas fa-plus-circle me-1"></i> Add Supplier</a>
  </div>

  <!-- 🔍 Search Bar -->
  <form method="GET" class="mb-2 d-flex align-items-center gap-2">
    <input type="text" name="q" value="<?= htmlspecialchars($search) ?>" class="form-control form-control-sm" placeholder="Search name or KRA PIN...">
    <button class="btn btn-sm btn-outline-dark">Search</button>
    <?php if ($search): ?>
      <a href="list.php" class="btn btn-sm btn-outline-secondary">Clear</a>
    <?php endif; ?>
  </form>

  <?php include '../../includes/alerts.php'; ?>

  <div class="card shadow-sm border-0">
    <div class="card-body p-2 table-responsive">
      <table class="table table-bordered table-hover table-sm align-middle small">
        <thead class="table-dark">
          <tr>
            <th>#</th>
            <th>Name</th>
            <th>KRA PIN</th>
            <th>Contact</th>
            <th>Bank</th>
            <th>Credit</th>
            <th class="text-center">Actions</th>
          </tr>
        </thead>
        <tbody>
          <?php if ($result->num_rows > 0): $n = 1; ?>
            <?php while ($s = $result->fetch_assoc()): ?>
              <tr>
                <td><?= $n++ ?></td>
                <td class="fw-semibold"><?= htmlspecialchars($s['name']) ?></td>
                <td><?= htmlspecialchars($s['kra_pin']) ?></td>
                <td>
                  <i class="fas fa-user"></i> <?= htmlspecialchars($s['contact_person']) ?><br>
                  <i class="fas fa-phone"></i> <?= htmlspecialchars($s['phone']) ?><br>
                  <small><i class="fas fa-envelope"></i> <?= htmlspecialchars($s['email']) ?></small>
                </td>
                <td>
                  <?= htmlspecialchars($s['bank_name']) ?><br>
                  <small><?= htmlspecialchars($s['branch_name']) ?> - <?= htmlspecialchars($s['account_no']) ?></small>
                </td>
                <td>
                  <span class="badge bg-secondary"><?= $s['credit_days'] ?>d</span>
                  <span class="badge bg-info text-dark">KSh <?= number_format($s['credit_limit'], 0) ?></span>
                </td>
                <td class="text-center">
                  <div class="d-flex justify-content-center gap-1">
                    <a href="view.php?id=<?= $s['id'] ?>" class="btn btn-sm btn-outline-primary" title="View"><i class="fas fa-eye"></i></a>
                    <a href="edit.php?id=<?= $s['id'] ?>" class="btn btn-sm btn-outline-success" title="Edit"><i class="fas fa-edit"></i></a>
                    <!-- Optional delete -->
                    <!-- <a href="delete.php?id=<?= $s['id'] ?>" class="btn btn-sm btn-outline-danger" title="Delete"><i class="fas fa-trash"></i></a> -->
                  </div>
                </td>
              </tr>
            <?php endwhile; ?>
          <?php else: ?>
            <tr><td colspan="7" class="text-center text-muted">No suppliers found.</td></tr>
          <?php endif; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
