<?php
session_start();
require_once '../../config/db.php';

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
  header("Location: list.php");
  exit;
}

if (!isset($_POST['csrf_token']) || $_POST['csrf_token'] !== $_SESSION['csrf_token']) {
  $_SESSION['error'] = "CSRF validation failed.";
  header("Location: list.php");
  exit;
}

// Sanitize inputs
$id             = (int) $_POST['id'];
$name           = trim($_POST['name']);
$kra_pin        = trim($_POST['kra_pin']);
$contact_person = trim($_POST['contact_person']);
$phone          = trim($_POST['phone']);
$email          = trim($_POST['email']);
$bank_name      = trim($_POST['bank_name']);
$branch_name    = trim($_POST['branch_name']);
$account_no     = trim($_POST['account_no']);
$credit_days    = (int) $_POST['credit_days'];
$credit_limit   = round((float) $_POST['credit_limit'], 2);

// Update supplier
$stmt = $conn->prepare("
  UPDATE suppliers SET 
    name = ?, kra_pin = ?, contact_person = ?, phone = ?, email = ?, 
    bank_name = ?, branch_name = ?, account_no = ?, credit_days = ?, credit_limit = ?
  WHERE id = ?
");

$stmt->bind_param(
  "ssssssssidi",
  $name, $kra_pin, $contact_person, $phone, $email,
  $bank_name, $branch_name, $account_no, $credit_days, $credit_limit, $id
);

if ($stmt->execute()) {
  $_SESSION['success'] = "✅ Supplier updated successfully.";
} else {
  $_SESSION['error'] = "❌ Update failed: " . $stmt->error;
}

header("Location: list.php");
exit;
