<?php
session_start();
require_once '../config/db.php';
include '../auth/auth_check.php';

if ($_SESSION['role'] !== 'Admin') {
    header("Location: ../unauthorized.php");
    exit;
}

$id = $_GET['id'] ?? 0;

// Fetch user data
$stmt = $conn->prepare("SELECT * FROM users WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$user = $stmt->get_result()->fetch_assoc();

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $full_name = $_POST['full_name'];
    $username = $_POST['username'];
    $id_number = $_POST['id_number'];
    $phone = $_POST['phone'];
    $status = $_POST['status'];
    $role_id = $_POST['role_id'];

    $update = $conn->prepare("UPDATE users SET full_name=?, username=?, id_number=?, phone=?, status=?, role_id=? WHERE id=?");
    $update->bind_param("ssssssi", $full_name, $username, $id_number, $phone, $status, $role_id, $id);
    $update->execute();

    header("Location: list_users.php");
    exit;
}

// Fetch roles
$roles = $conn->query("SELECT * FROM user_roles")->fetch_all(MYSQLI_ASSOC);
include '../includes/layout2.php';
?>

<div class="container mt-4">
  <h4 class="mb-3">✏️ Edit User</h4>
  <form method="post" class="row g-3">
    <div class="col-md-6">
      <label class="form-label">Full Name</label>
      <input type="text" name="full_name" value="<?= $user['full_name'] ?>" class="form-control" required>
    </div>
    <div class="col-md-6">
      <label class="form-label">Username</label>
      <input type="text" name="username" value="<?= $user['username'] ?>" class="form-control" required>
    </div>
    <div class="col-md-6">
      <label class="form-label">ID Number</label>
      <input type="text" name="id_number" value="<?= $user['id_number'] ?>" class="form-control" required>
    </div>
    <div class="col-md-6">
      <label class="form-label">Phone</label>
      <input type="text" name="phone" value="<?= $user['phone'] ?>" class="form-control" required>
    </div>
    <div class="col-md-6">
      <label class="form-label">Status</label>
      <select name="status" class="form-select">
        <option value="active" <?= $user['status'] == 'active' ? 'selected' : '' ?>>Active</option>
        <option value="inactive" <?= $user['status'] == 'inactive' ? 'selected' : '' ?>>Inactive</option>
      </select>
    </div>
    <div class="col-md-6">
      <label class="form-label">Role</label>
      <select name="role_id" class="form-select">
        <?php foreach ($roles as $role): ?>
          <option value="<?= $role['id'] ?>" <?= $role['id'] == $user['role_id'] ? 'selected' : '' ?>>
            <?= $role['role_name'] ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-12">
      <button type="submit" class="btn btn-success">💾 Update User</button>
    </div>
  </form>
</div>
